/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.ILabeledInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public abstract class CaseControlLikeSampling<I extends ILabeledInstance<?>, D extends IDataset<I>>
extends ASamplingAlgorithm<D> {
    protected Random rand;
    protected List<Pair<I, Double>> probabilityBoundaries = null;

    protected CaseControlLikeSampling(D input) {
        super(input);
    }

    public List<Pair<I, Double>> getProbabilityBoundaries() {
        return this.probabilityBoundaries;
    }

    public void setProbabilityBoundaries(List<Pair<I, Double>> probabilityBoundaries) {
        this.probabilityBoundaries = probabilityBoundaries;
    }

    protected HashMap<Object, Integer> countClassOccurrences(D dataset) {
        HashMap<Object, Integer> classOccurrences = new HashMap<Object, Integer>();
        for (ILabeledInstance instance : dataset) {
            boolean classExists = false;
            for (Object clazz : classOccurrences.keySet()) {
                if (!clazz.equals(instance.getTargetValue())) continue;
                classExists = true;
            }
            if (classExists) {
                classOccurrences.put(instance.getTargetValue(), classOccurrences.get(instance.getTargetValue()) + 1);
                continue;
            }
            classOccurrences.put(instance.getTargetValue(), 0);
        }
        return classOccurrences;
    }

    protected List<Pair<I, Double>> calculateInstanceBoundaries(HashMap<Object, Integer> classOccurrences, int numberOfClasses) {
        double boundaryOfCurrentInstance = 0.0;
        ArrayList<Pair<I, Double>> boundaries = new ArrayList<Pair<I, Double>>();
        for (ILabeledInstance instance : (IDataset)this.getInput()) {
            boundaries.add(new Pair((Object)instance, (Object)(boundaryOfCurrentInstance += 1.0 / (double)classOccurrences.get(instance.getTargetValue()).intValue() / (double)numberOfClasses)));
        }
        return boundaries;
    }
}

