/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories;

import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.INumericLabeledAttributeArrayInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.GmeansSampling;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.IRerunnableSamplingAlgorithmFactory;
import java.util.Random;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.ManhattanDistance;

public class GmeansSamplingFactory<I extends INumericLabeledAttributeArrayInstance<? extends Number>, D extends IDataset<I>>
implements IRerunnableSamplingAlgorithmFactory<D, GmeansSampling<I, D>> {
    private GmeansSampling<I, D> previousRun;
    private long clusterSeed = System.currentTimeMillis();
    private DistanceMeasure distanceMeassure = new ManhattanDistance();

    @Override
    public void setPreviousRun(GmeansSampling<I, D> previousRun) {
        this.previousRun = previousRun;
    }

    public void setClusterSeed(long clusterSeed) {
        this.clusterSeed = clusterSeed;
    }

    public void setDistanceMeassure(DistanceMeasure distanceMeassure) {
        this.distanceMeassure = distanceMeassure;
    }

    @Override
    public GmeansSampling<I, D> getAlgorithm(int sampleSize, D inputDataset, Random random) {
        GmeansSampling gmeansSampling = new GmeansSampling(this.clusterSeed, inputDataset);
        gmeansSampling.setSampleSize(sampleSize);
        gmeansSampling.setDistanceMeassure(this.distanceMeassure);
        if (this.previousRun != null && this.previousRun.getClusterResults() != null) {
            gmeansSampling.setClusterResults(this.previousRun.getClusterResults());
        }
        return gmeansSampling;
    }
}

