/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories;

import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.ILabeledAttributeArrayInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol.LocalCaseControlSampling;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.IRerunnableSamplingAlgorithmFactory;
import java.util.Random;

public class LocalCaseControlSamplingFactory<I extends ILabeledAttributeArrayInstance<?>, D extends IDataset<I>>
implements IRerunnableSamplingAlgorithmFactory<D, LocalCaseControlSampling<I, D>> {
    private LocalCaseControlSampling<I, D> previousRun = null;
    private int preSampleSize = -1;

    @Override
    public void setPreviousRun(LocalCaseControlSampling<I, D> previousRun) {
        this.previousRun = previousRun;
    }

    public void setPreSampleSize(int preSampleSize) {
        this.preSampleSize = preSampleSize;
    }

    @Override
    public LocalCaseControlSampling<I, D> getAlgorithm(int sampleSize, D inputDataset, Random random) {
        LocalCaseControlSampling localCaseControlSampling = new LocalCaseControlSampling(random, this.preSampleSize, inputDataset);
        if (this.previousRun != null && this.previousRun.getProbabilityBoundaries() != null) {
            localCaseControlSampling.setProbabilityBoundaries(this.previousRun.getProbabilityBoundaries());
            localCaseControlSampling.setChosenInstance(this.previousRun.getChosenInstance());
        }
        localCaseControlSampling.setSampleSize(sampleSize);
        return localCaseControlSampling;
    }
}

