/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories;

import ai.libs.jaicore.ml.core.dataset.IOrderedDataset;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.IRerunnableSamplingAlgorithmFactory;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.stratified.sampling.IStratiAmountSelector;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.stratified.sampling.IStratiAssigner;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.stratified.sampling.StratifiedSampling;
import java.util.Random;

public class StratifiedSamplingFactory<I, D extends IOrderedDataset<I>>
implements IRerunnableSamplingAlgorithmFactory<D, StratifiedSampling<I, D>> {
    private IStratiAmountSelector<D> stratiAmountSelector;
    private IStratiAssigner<I, D> stratiAssigner;
    private StratifiedSampling<I, D> previousRun = null;

    public StratifiedSamplingFactory(IStratiAmountSelector<D> stratiAmountSelector, IStratiAssigner<I, D> stratiAssigner) {
        this.stratiAmountSelector = stratiAmountSelector;
        this.stratiAssigner = stratiAssigner;
    }

    @Override
    public void setPreviousRun(StratifiedSampling<I, D> previousRun) {
        this.previousRun = previousRun;
    }

    @Override
    public StratifiedSampling<I, D> getAlgorithm(int sampleSize, D inputDataset, Random random) {
        StratifiedSampling<I, D> stratifiedSampling = new StratifiedSampling<I, D>(this.stratiAmountSelector, this.stratiAssigner, random, inputDataset);
        stratifiedSampling.setSampleSize(sampleSize);
        if (this.previousRun != null && this.previousRun.getStrati() != null) {
            stratifiedSampling.setStrati(this.previousRun.getStrati());
        }
        return stratifiedSampling;
    }
}

