/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.standard;

import ai.libs.jaicore.ml.core.dataset.ContainsNonNumericAttributesException;
import ai.libs.jaicore.ml.core.dataset.INumericLabeledAttributeArrayInstance;
import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.categorical.CategoricalAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.primitive.NumericAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.transformer.OneHotEncodingTransformer;
import java.util.LinkedList;
import java.util.List;

public class SimpleInstance<L>
implements INumericLabeledAttributeArrayInstance<L> {
    private static final long serialVersionUID = -6945848041078727475L;
    private final OneHotEncodingTransformer oneHotEncoder = new OneHotEncodingTransformer();
    private final List<IAttributeValue<?>> attributeValues;
    private final L targetValue;

    public SimpleInstance(List<IAttributeValue<?>> attributeValues, L targetValue) {
        this.attributeValues = attributeValues;
        this.targetValue = targetValue;
    }

    @Override
    public <T> IAttributeValue<T> getAttributeValueAtPosition(int position, Class<T> type) {
        return this.attributeValues.get(position);
    }

    @Override
    public L getTargetValue() {
        return this.targetValue;
    }

    @Override
    public double[] getAsDoubleVector() throws ContainsNonNumericAttributesException {
        LinkedList<Double> doubleList = new LinkedList<Double>();
        for (IAttributeValue<?> val : this.attributeValues) {
            if (val instanceof CategoricalAttributeValue) {
                double[] transformedValues;
                for (double doubVal : transformedValues = this.oneHotEncoder.transformAttribute(val)) {
                    doubleList.add(doubVal);
                }
                continue;
            }
            if (val instanceof NumericAttributeValue) {
                doubleList.add((Double)((NumericAttributeValue)val).getValue());
                continue;
            }
            throw new ContainsNonNumericAttributesException("Could not convert all the attribute values to a double vector representation.");
        }
        return doubleList.stream().mapToDouble(x -> x).toArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IAttributeValue<?> val : this.attributeValues) {
            sb.append(val.getValue());
            sb.append(";");
        }
        sb.append(this.targetValue);
        return sb.toString();
    }

    @Override
    public IAttributeValue<Double> getAttributeValue(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAttributeValue<?>[] getAllAttributeValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfAttributes() {
        throw new UnsupportedOperationException();
    }
}

