/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.weka;

import ai.libs.jaicore.basic.sets.ElementDecorator;
import ai.libs.jaicore.ml.core.dataset.ContainsNonNumericAttributesException;
import ai.libs.jaicore.ml.core.dataset.INumericLabeledAttributeArrayInstance;
import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeType;
import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.categorical.CategoricalAttributeType;
import ai.libs.jaicore.ml.core.dataset.attribute.categorical.CategoricalAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.primitive.BooleanAttributeType;
import ai.libs.jaicore.ml.core.dataset.attribute.primitive.BooleanAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.primitive.NumericAttributeType;
import ai.libs.jaicore.ml.core.dataset.attribute.primitive.NumericAttributeValue;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstancesUtil;
import weka.core.Attribute;
import weka.core.Instance;

public class WekaInstance<L>
extends ElementDecorator<Instance>
implements INumericLabeledAttributeArrayInstance<L> {
    public WekaInstance(Instance instance) {
        super((Object)instance);
    }

    @Override
    public <T> IAttributeValue<T> getAttributeValueAtPosition(int position, Class<T> type) {
        return this.getAttributeValue(((Instance)this.getElement()).attribute(position), type);
    }

    private <T> IAttributeValue<T> getAttributeValue(Attribute a, Class<T> type) {
        IAttributeType<?> t = WekaInstancesUtil.transformWEKAAttributeToAttributeType(a);
        if (t instanceof BooleanAttributeType) {
            return new BooleanAttributeValue((BooleanAttributeType)t, ((Instance)this.getElement()).value(a) == 1.0);
        }
        if (t instanceof CategoricalAttributeType) {
            return new CategoricalAttributeValue((CategoricalAttributeType)t, ((Instance)this.getElement()).stringValue(a));
        }
        if (t instanceof NumericAttributeType) {
            return new NumericAttributeValue((NumericAttributeType)t, ((Instance)this.getElement()).value(a));
        }
        throw new IllegalArgumentException("Type " + type + " is not a valid type!");
    }

    @Override
    public L getTargetValue() {
        IAttributeType<?> t = WekaInstancesUtil.transformWEKAAttributeToAttributeType(((Instance)this.getElement()).classAttribute());
        return (L)t.buildAttributeValue(((Instance)this.getElement()).classValue()).getValue();
    }

    @Override
    public double[] getAsDoubleVector() throws ContainsNonNumericAttributesException {
        return ((Instance)this.getElement()).toDoubleArray();
    }

    @Override
    public IAttributeValue<Double> getAttributeValue(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAttributeValue<?>[] getAllAttributeValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfAttributes() {
        throw new UnsupportedOperationException();
    }
}

