/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.optimizing.graddesc;

import ai.libs.jaicore.math.linearalgebra.DenseDoubleVector;
import ai.libs.jaicore.math.linearalgebra.Vector;
import ai.libs.jaicore.ml.core.optimizing.IGradientDescendableFunction;
import ai.libs.jaicore.ml.core.optimizing.IGradientFunction;

public class BlackBoxGradient
implements IGradientFunction {
    private final double precision;
    private final IGradientDescendableFunction function;

    public BlackBoxGradient(IGradientDescendableFunction underlyingFunction, double precision) {
        this.precision = precision;
        this.function = underlyingFunction;
    }

    @Override
    public Vector apply(Vector xVec) {
        DenseDoubleVector gradient = new DenseDoubleVector(xVec.length());
        double fX = this.function.apply(xVec);
        DenseDoubleVector xPrime = new DenseDoubleVector(xVec.asArray());
        for (int i = 0; i < xVec.length(); ++i) {
            if (i > 0) {
                xPrime.setValue(i - 1, xPrime.getValue(i - 1) - this.precision);
            }
            xPrime.setValue(i, xPrime.getValue(i) + this.precision);
            double fXPrime = this.function.apply((Vector)xPrime);
            double partial = fXPrime - fX;
            gradient.setValue(i, partial);
        }
        return gradient;
    }
}

