/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.dyadranking.loss;

import ai.libs.jaicore.ml.dyadranking.Dyad;
import ai.libs.jaicore.ml.dyadranking.dataset.IDyadRankingInstance;
import ai.libs.jaicore.ml.dyadranking.loss.DyadRankingLossFunction;
import java.util.ArrayList;

public class TopKOfPredicted
implements DyadRankingLossFunction {
    private int k;

    public TopKOfPredicted(int k) {
        this.k = k;
    }

    @Override
    public double loss(IDyadRankingInstance actual, IDyadRankingInstance predicted) {
        ArrayList<Dyad> topKDyads = new ArrayList<Dyad>();
        for (int i = 0; i < this.k; ++i) {
            topKDyads.add(actual.getDyadAtPosition(i));
        }
        int incorrectNum = 0;
        for (int i = 0; i < this.k; ++i) {
            Dyad topKDyadInPred = predicted.getDyadAtPosition(i);
            if (topKDyads.contains(topKDyadInPred)) continue;
            ++incorrectNum;
        }
        if (incorrectNum == 0) {
            return 0.0;
        }
        return (double)incorrectNum / (double)this.k;
    }
}

