/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.dyadranking.util;

import ai.libs.jaicore.math.linearalgebra.Vector;
import ai.libs.jaicore.ml.dyadranking.Dyad;
import ai.libs.jaicore.ml.dyadranking.util.AbstractDyadScaler;
import java.util.List;

public class DyadStandardScaler
extends AbstractDyadScaler {
    private static final long serialVersionUID = 1L;

    @Override
    public void transformInstances(Dyad dyad, List<Integer> ignoredIndices) {
        for (int i = 0; i < dyad.getInstance().length(); ++i) {
            if (ignoredIndices.contains(i)) continue;
            double value = dyad.getInstance().getValue(i);
            value -= this.statsX[i].getMean();
            if (this.statsX[i].getStandardDeviation() != 0.0) {
                value /= this.statsX[i].getStandardDeviation();
            }
            dyad.getInstance().setValue(i, value);
        }
    }

    @Override
    public void transformAlternatives(Dyad dyad, List<Integer> ignoredIndices) {
        for (int i = 0; i < dyad.getAlternative().length(); ++i) {
            if (ignoredIndices.contains(i)) continue;
            double value = dyad.getAlternative().getValue(i);
            value -= this.statsY[i].getMean();
            if (this.statsY[i].getStandardDeviation() != 0.0) {
                value /= this.statsY[i].getStandardDeviation();
            }
            dyad.getAlternative().setValue(i, value);
        }
    }

    @Override
    public void transformInstaceVector(Vector vector, List<Integer> ignoredIndices) {
        for (int i = 0; i < vector.length(); ++i) {
            if (ignoredIndices.contains(i)) continue;
            double value = vector.getValue(i);
            value -= this.statsX[i].getMean();
            if (this.statsX[i].getStandardDeviation() != 0.0) {
                value /= this.statsX[i].getStandardDeviation();
            }
            vector.setValue(i, value);
        }
    }
}

