/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.evaluation.evaluators.weka;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.basic.events.IEventEmitter;
import ai.libs.jaicore.ml.core.dataset.DatasetCreationException;
import ai.libs.jaicore.ml.core.dataset.ILabeledAttributeArrayInstance;
import ai.libs.jaicore.ml.core.dataset.IOrderedLabeledAttributeArrayDataset;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.ISamplingAlgorithmFactory;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import ai.libs.jaicore.ml.interfaces.LearningCurve;
import ai.libs.jaicore.ml.learningcurve.extrapolation.InvalidAnchorPointsException;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolatedEvent;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolationMethod;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolator;
import com.google.common.eventbus.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;

public class LearningCurveExtrapolationEvaluator<I extends ILabeledAttributeArrayInstance<?>, D extends IOrderedLabeledAttributeArrayDataset<I, ?>>
implements IClassifierEvaluator,
ILoggingCustomizable,
IEventEmitter {
    private Logger logger = LoggerFactory.getLogger(LearningCurveExtrapolationEvaluator.class);
    private int[] anchorpoints;
    private ISamplingAlgorithmFactory<D, ? extends ASamplingAlgorithm<D>> samplingAlgorithmFactory;
    private D dataset;
    private double trainSplitForAnchorpointsMeasurement;
    private LearningCurveExtrapolationMethod extrapolationMethod;
    private long seed;
    private int fullDatasetSize = -1;
    private static final boolean EVALUATE_ACCURACY = false;
    private final EventBus eventBus = new EventBus();

    public LearningCurveExtrapolationEvaluator(int[] anchorpoints, ISamplingAlgorithmFactory<D, ? extends ASamplingAlgorithm<D>> samplingAlgorithmFactory, D dataset, double trainSplitForAnchorpointsMeasurement, LearningCurveExtrapolationMethod extrapolationMethod, long seed) {
        this.anchorpoints = anchorpoints;
        this.samplingAlgorithmFactory = samplingAlgorithmFactory;
        this.dataset = dataset;
        this.trainSplitForAnchorpointsMeasurement = trainSplitForAnchorpointsMeasurement;
        this.extrapolationMethod = extrapolationMethod;
        this.seed = seed;
    }

    public void setFullDatasetSize(int fullDatasetSize) {
        this.fullDatasetSize = fullDatasetSize;
    }

    public Double evaluate(Classifier classifier) throws InterruptedException, ObjectEvaluationFailedException {
        this.logger.info("Receive request to evaluate classifier {}", (Object)classifier);
        try {
            LearningCurveExtrapolator extrapolator = new LearningCurveExtrapolator(this.extrapolationMethod, classifier, this.dataset, this.trainSplitForAnchorpointsMeasurement, this.anchorpoints, this.samplingAlgorithmFactory, this.seed);
            extrapolator.setLoggerName(this.getLoggerName() + ".extrapolator");
            this.logger.debug("Extrapolating learning curve.");
            LearningCurve learningCurve = extrapolator.extrapolateLearningCurve();
            this.logger.debug("Retrieved learning curve {}.", (Object)learningCurve);
            this.eventBus.post((Object)new LearningCurveExtrapolatedEvent(extrapolator));
            int evaluationPoint = this.dataset.size();
            if (this.fullDatasetSize != -1) {
                evaluationPoint = this.fullDatasetSize;
            }
            Double val = 1.0 - learningCurve.getCurveValue(evaluationPoint);
            this.logger.info("Estimate for performance on full dataset is {}", (Object)val);
            return val;
        }
        catch (AlgorithmException | DatasetCreationException | InvalidAnchorPointsException e) {
            throw new ObjectEvaluationFailedException("Could not compute a score based on the learning curve.", e);
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
    }
}

