/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.evaluation.evaluators.weka;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.basic.events.IEvent;
import ai.libs.jaicore.basic.events.IEventEmitter;
import ai.libs.jaicore.ml.WekaUtil;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.events.MCCVSplitEvaluationEvent;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.ISplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.weka.dataset.splitter.IDatasetSplitter;
import ai.libs.jaicore.ml.weka.dataset.splitter.MulticlassClassStratifiedSplitter;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class MonteCarloCrossValidationEvaluator
implements IClassifierEvaluator,
ILoggingCustomizable,
IEventEmitter {
    private final EventBus eventBus = new EventBus();
    private boolean hasListeners;
    private Logger logger = LoggerFactory.getLogger(MonteCarloCrossValidationEvaluator.class);
    private boolean canceled = false;
    private final IDatasetSplitter datasetSplitter;
    private final int repeats;
    private final Instances data;
    private final double trainingPortion;
    private final long seed;
    private final ISplitBasedClassifierEvaluator<Double> splitBasedEvaluator;
    private final Map<Long, List<Instances>> splitCache = new HashMap<Long, List<Instances>>();

    public MonteCarloCrossValidationEvaluator(ISplitBasedClassifierEvaluator<Double> splitBasedEvaluator, IDatasetSplitter datasetSplitter, int repeats, Instances data, double trainingPortion, long seed) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot work with NULL data");
        }
        if (splitBasedEvaluator == null) {
            throw new IllegalArgumentException("Cannot work with NULL split based evaluator");
        }
        this.datasetSplitter = datasetSplitter;
        this.repeats = repeats;
        this.splitBasedEvaluator = splitBasedEvaluator;
        if (this.splitBasedEvaluator instanceof IEventEmitter) {
            ((IEventEmitter)splitBasedEvaluator).registerListener((Object)this);
        }
        this.data = data;
        this.trainingPortion = trainingPortion;
        this.seed = seed;
    }

    public MonteCarloCrossValidationEvaluator(ISplitBasedClassifierEvaluator<Double> splitBasedEvaluator, int repeats, Instances data, double trainingPortion, long seed) {
        this(splitBasedEvaluator, new MulticlassClassStratifiedSplitter(), repeats, data, trainingPortion, seed);
    }

    public void cancel() {
        this.logger.info("Received cancel");
        this.canceled = true;
    }

    public Double evaluate(Classifier pl) throws ObjectEvaluationFailedException, InterruptedException {
        return this.evaluate(pl, new DescriptiveStatistics());
    }

    public Double evaluate(Classifier pl, DescriptiveStatistics stats) throws ObjectEvaluationFailedException, InterruptedException {
        if (pl == null) {
            throw new IllegalArgumentException("Cannot compute score for null pipeline!");
        }
        long startTimestamp = System.currentTimeMillis();
        this.logger.info("Starting MMCV evaluation of {} (Description: {})", (Object)pl.getClass().getName(), (Object)WekaUtil.getClassifierDescriptor(pl));
        for (int i = 0; i < this.repeats && !this.canceled; ++i) {
            this.logger.debug("Obtaining predictions of {} for split #{}/{}", new Object[]{pl, i + 1, this.repeats});
            if (Thread.interrupted()) {
                this.logger.info("MCCV has been interrupted, leaving MCCV.");
                throw new InterruptedException("MCCV has been interrupted.");
            }
            if (!this.splitCache.containsKey(this.seed + (long)i)) {
                this.splitCache.put(this.seed + (long)i, this.datasetSplitter.split(this.data, this.seed + (long)i, this.trainingPortion));
            }
            List<Instances> split = this.splitCache.get(this.seed + (long)i);
            try {
                long startTimeForSplitEvaluation = System.currentTimeMillis();
                double score = this.splitBasedEvaluator.evaluateSplit(pl, split.get(0), split.get(1));
                if (this.hasListeners) {
                    this.eventBus.post((Object)new MCCVSplitEvaluationEvent(pl, split.get(0).size(), split.get(1).size(), (int)(System.currentTimeMillis() - startTimeForSplitEvaluation), score));
                }
                this.logger.info("Score for evaluation of {} with split #{}/{}: {} after {}ms", new Object[]{pl.getClass().getName(), i + 1, this.repeats, score, System.currentTimeMillis() - startTimestamp});
                stats.addValue(score);
                continue;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ObjectEvaluationFailedException("Could not evaluate classifier!", (Throwable)e);
            }
        }
        Double score = stats.getMean();
        this.logger.info("Obtained score of {} for classifier {} in {}ms.", new Object[]{score, pl.getClass().getName(), System.currentTimeMillis() - startTimestamp});
        return score;
    }

    public ISplitBasedClassifierEvaluator<Double> getBridge() {
        return this.splitBasedEvaluator;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger of {} from {} to {}", new Object[]{this, this.logger.getName(), name});
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched logger of {} to {}", (Object)this, (Object)name);
    }

    public void registerListener(Object listener) {
        this.hasListeners = true;
        this.eventBus.register(listener);
    }

    @Subscribe
    public void receiveEvent(IEvent event) {
        this.eventBus.post((Object)event);
    }
}

