/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.evaluation.evaluators.weka;

import ai.libs.jaicore.ml.WekaUtil;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.Evaluation;
import weka.core.Instances;

public class SingleRandomSplitClassifierEvaluator
implements IClassifierEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(SingleRandomSplitClassifierEvaluator.class);
    private final Instances data;
    private int seed;
    private float trainingPortion = 0.7f;

    public SingleRandomSplitClassifierEvaluator(Instances data) {
        this.data = data;
    }

    public Double evaluate(Classifier c) throws InterruptedException {
        List<Instances> split = WekaUtil.getStratifiedSplit(this.data, this.seed >= 0 ? (long)this.seed : System.currentTimeMillis(), this.trainingPortion);
        try {
            c.buildClassifier(split.get(0));
            Evaluation eval = new Evaluation(split.get(0));
            eval.evaluateModel(c, split.get(1), new Object[0]);
            Double score = eval.pctIncorrect();
            return score;
        }
        catch (Throwable e) {
            logger.warn("Evaluation of classifier failed due Exception {} with message {}. Returning null.", (Object)e.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public float getTrainingPortion() {
        return this.trainingPortion;
    }

    public void setTrainingPortion(float trainingPortion) {
        this.trainingPortion = trainingPortion;
    }
}

