/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.metafeatures;

import ai.libs.jaicore.ml.metafeatures.DatasetCharacterizerInitializationFailedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.time.StopWatch;
import org.openml.webapplication.fantail.dc.Characterizer;
import org.openml.webapplication.fantail.dc.landmarking.GenericLandmarker;
import org.openml.webapplication.fantail.dc.statistical.Cardinality;
import org.openml.webapplication.fantail.dc.statistical.NominalAttDistinctValues;
import org.openml.webapplication.fantail.dc.statistical.SimpleMetaFeatures;
import org.openml.webapplication.fantail.dc.statistical.Statistical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Instances;
import weka.core.Utils;

public class GlobalCharacterizer
extends Characterizer {
    private final Logger logger = LoggerFactory.getLogger(GlobalCharacterizer.class);
    protected static final String PREPROCESSING_PREFIX = "-E \"weka.attributeSelection.CfsSubsetEval -P 1 -E 1\" -S \"weka.attributeSelection.BestFirst -D 1 -N 5\" -W ";
    protected static final String CP_IBK = "weka.classifiers.lazy.IBk";
    protected static final String CP_NB = "weka.classifiers.bayes.NaiveBayes";
    protected static final String CP_ASC = "weka.classifiers.meta.AttributeSelectedClassifier";
    protected static final String CP_DS = "weka.classifiers.trees.DecisionStump";
    protected String[] ids;
    protected ArrayList<Characterizer> characterizers;
    protected Map<Characterizer, String> characterizerNames;
    protected Map<String, Double> computationTimes = new HashMap<String, Double>();

    public GlobalCharacterizer() throws DatasetCharacterizerInitializationFailedException {
        this.logger.trace("Initialize");
        try {
            this.initializeCharacterizers();
        }
        catch (Exception e) {
            throw new DatasetCharacterizerInitializationFailedException(e);
        }
        this.initializeCharacterizerNames();
        this.initializeMetaFeatureIds();
    }

    public Map<String, Double> characterize(Instances instances) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Characterize dataset \"{}\" ...", (Object)instances.relationName());
        }
        TreeMap<String, Double> metaFeatures = new TreeMap<String, Double>();
        StopWatch watch = new StopWatch();
        this.characterizers.forEach(characterizer -> {
            try {
                watch.reset();
                watch.start();
                metaFeatures.putAll(characterizer.characterize(instances));
                watch.stop();
                this.computationTimes.put(characterizer.toString(), Double.valueOf(watch.getTime()));
            }
            catch (Exception e) {
                for (String metaFeature : characterizer.getIDs()) {
                    metaFeatures.put(metaFeature, Double.NaN);
                }
                this.computationTimes.put(characterizer.toString(), Double.NaN);
            }
        });
        this.logger.trace("Done characterizing dataset. Feature length: {}", (Object)metaFeatures.size());
        return metaFeatures;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Characterizer characterizer : this.characterizers) {
            String[] baseCharacterizerIds;
            builder.append(characterizer.toString());
            builder.append(System.lineSeparator());
            for (String id : baseCharacterizerIds = characterizer.getIDs()) {
                builder.append(id + ",");
            }
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    public List<Characterizer> getCharacterizers() {
        return this.characterizers;
    }

    public Map<String, Double> getMetaFeatureComputationTimes() {
        return this.computationTimes;
    }

    public List<String> getCharacterizerNames() {
        ArrayList<String> names = new ArrayList<String>();
        this.characterizerNames.values().forEach(names::add);
        return names;
    }

    public Map<Characterizer, String> getCharacterizerNamesMappings() {
        return this.characterizerNames;
    }

    public Map<String, List<String>> getCharacterizerGroups() {
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        this.characterizerNames.forEach((characterizer, name) -> results.put((String)name, Arrays.asList(characterizer.getIDs())));
        return results;
    }

    public String[] getIDs() {
        return this.ids;
    }

    protected void initializeCharacterizers() throws Exception {
        this.characterizers = new ArrayList();
        this.addNoProbingCharacterizers(this.characterizers);
        this.addLandmarkerCharacterizers(this.characterizers);
    }

    protected void addNoProbingCharacterizers(ArrayList<Characterizer> characterizerList) {
        characterizerList.addAll(Arrays.asList(new SimpleMetaFeatures(), new Statistical(), new NominalAttDistinctValues(), new Cardinality()));
    }

    protected void addLandmarkerCharacterizers(ArrayList<Characterizer> characterizerList) throws Exception {
        characterizerList.addAll(Arrays.asList(new GenericLandmarker("kNN1N", CP_IBK, 2, null), new GenericLandmarker("NaiveBayes", CP_NB, 2, null), new GenericLandmarker("DecisionStump", CP_DS, 2, null), new GenericLandmarker("CfsSubsetEval_kNN1N", CP_ASC, 2, Utils.splitOptions((String)"-E \"weka.attributeSelection.CfsSubsetEval -P 1 -E 1\" -S \"weka.attributeSelection.BestFirst -D 1 -N 5\" -W weka.classifiers.lazy.IBk")), new GenericLandmarker("CfsSubsetEval_NaiveBayes", CP_ASC, 2, Utils.splitOptions((String)"-E \"weka.attributeSelection.CfsSubsetEval -P 1 -E 1\" -S \"weka.attributeSelection.BestFirst -D 1 -N 5\" -W weka.classifiers.bayes.NaiveBayes")), new GenericLandmarker("CfsSubsetEval_DecisionStump", CP_ASC, 2, Utils.splitOptions((String)"-E \"weka.attributeSelection.CfsSubsetEval -P 1 -E 1\" -S \"weka.attributeSelection.BestFirst -D 1 -N 5\" -W weka.classifiers.trees.DecisionStump"))));
        StringBuilder zeroes = new StringBuilder();
        zeroes.append("0");
        for (int i = 1; i <= 3; ++i) {
            zeroes.append("0");
            String[] j48Option = new String[]{"-C", "." + zeroes.toString() + "1"};
            characterizerList.add((Characterizer)new GenericLandmarker("J48." + zeroes.toString() + "1.", "weka.classifiers.trees.J48", 2, j48Option));
            String[] repOption = new String[]{"-L", "" + i};
            characterizerList.add((Characterizer)new GenericLandmarker("REPTreeDepth" + i, "weka.classifiers.trees.REPTree", 2, repOption));
            String[] randomtreeOption = new String[]{"-depth", "" + i};
            characterizerList.add((Characterizer)new GenericLandmarker("RandomTreeDepth" + i, "weka.classifiers.trees.RandomTree", 2, randomtreeOption));
        }
    }

    protected void initializeCharacterizerNames() {
        this.characterizerNames = new HashMap<Characterizer, String>();
        this.characterizers.forEach(characterizer -> {
            if (characterizer.getClass().equals(GenericLandmarker.class)) {
                String aUCName = characterizer.getIDs()[0];
                String name = aUCName.substring(0, aUCName.length() - 3);
                this.characterizerNames.put((Characterizer)characterizer, name);
            } else {
                this.characterizerNames.put((Characterizer)characterizer, characterizer.getClass().getSimpleName());
            }
        });
    }

    protected void initializeMetaFeatureIds() {
        ArrayList<String> metaFeatures = new ArrayList<String>();
        for (Characterizer characterizer : this.characterizers) {
            for (String metaFeature : characterizer.getIDs()) {
                metaFeatures.add(metaFeature);
            }
        }
        this.ids = metaFeatures.toArray(new String[metaFeatures.size()]);
    }
}

