/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.clusterbased.modifiedisac;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.ml.core.exception.TrainingException;
import ai.libs.jaicore.ml.ranking.clusterbased.GroupBasedRanker;
import ai.libs.jaicore.ml.ranking.clusterbased.customdatatypes.Group;
import ai.libs.jaicore.ml.ranking.clusterbased.customdatatypes.ProblemInstance;
import ai.libs.jaicore.ml.ranking.clusterbased.customdatatypes.RankingForGroup;
import ai.libs.jaicore.ml.ranking.clusterbased.modifiedisac.ClassifierRankingForGroup;
import ai.libs.jaicore.ml.ranking.clusterbased.modifiedisac.L1DistanceMetric;
import ai.libs.jaicore.ml.ranking.clusterbased.modifiedisac.ModifiedISACGroupBuilder;
import ai.libs.jaicore.ml.ranking.clusterbased.modifiedisac.ModifiedISACInstanceCollector;
import ai.libs.jaicore.ml.ranking.clusterbased.modifiedisac.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weka.core.Instance;

public class ModifiedISAC
extends GroupBasedRanker<double[], Instance, String> {
    private Map<double[], Integer> positionOfInstance = new HashMap<double[], Integer>();
    private ArrayList<ClassifierRankingForGroup> rankings = new ArrayList();
    private List<Group<double[], Instance>> foundCluster;
    private Normalizer norm;

    @Override
    public void buildRanker() throws TrainingException {
        ModifiedISACInstanceCollector collector;
        try {
            collector = new ModifiedISACInstanceCollector();
        }
        catch (Exception e) {
            throw new TrainingException("Could not build the ranker.", e);
        }
        List<ProblemInstance<Instance>> collectedInstances = collector.getProblemInstances();
        ArrayList<double[]> toClusterpoints = new ArrayList<double[]>();
        this.norm = new Normalizer(collectedInstances);
        this.norm.setupnormalize();
        for (ProblemInstance<Instance> tmp : collectedInstances) {
            toClusterpoints.add(this.norm.normalize(tmp.getInstance().toDoubleArray()));
        }
        ModifiedISACGroupBuilder builder = new ModifiedISACGroupBuilder();
        builder.setPoints(toClusterpoints);
        int tmp = 0;
        for (ProblemInstance<Instance> i : collectedInstances) {
            this.positionOfInstance.put(i.getInstance().toDoubleArray(), tmp);
            ++tmp;
        }
        this.foundCluster = builder.buildGroup(collectedInstances);
        this.constructRanking(collector);
    }

    private void constructRanking(ModifiedISACInstanceCollector collector) {
        for (Group<double[], Instance> c : this.foundCluster) {
            ArrayList<String> ranking = new ArrayList<String>();
            int[] tmp = new int[collector.getNumberOfClassifier()];
            double[] clusterMean = new double[collector.getNumberOfClassifier()];
            for (ProblemInstance<Instance> prob : c.getInstances()) {
                int myIndex = 0;
                for (Map.Entry<double[], Integer> instancePositionWithNumber : this.positionOfInstance.entrySet()) {
                    if (!Arrays.equals(instancePositionWithNumber.getKey(), prob.getInstance().toDoubleArray())) continue;
                    myIndex = instancePositionWithNumber.getValue();
                    break;
                }
                ArrayList<Pair<String, Double>> solutionsOfPoint = collector.getCollectedClassifierandPerformance().get(myIndex);
                for (int i = 0; i < solutionsOfPoint.size(); ++i) {
                    double perfo = (Double)solutionsOfPoint.get(i).getY();
                    if (Double.isNaN(perfo)) continue;
                    int n = i;
                    clusterMean[n] = clusterMean[n] + perfo;
                    int n2 = i;
                    tmp[n2] = tmp[n2] + 1;
                }
            }
            for (int i = 0; i < clusterMean.length; ++i) {
                clusterMean[i] = clusterMean[i] / (double)tmp[i];
            }
            List<String> allClassifier = collector.getAllClassifier();
            HashMap<String, Double> remainingCandidiates = new HashMap<String, Double>();
            for (int i = 0; i < clusterMean.length; ++i) {
                remainingCandidiates.put(allClassifier.get(i), clusterMean[i]);
            }
            while (!remainingCandidiates.isEmpty()) {
                double min = Double.MIN_VALUE;
                String classi = null;
                for (Map.Entry nameWithCandidate : remainingCandidiates.entrySet()) {
                    double candidate = (Double)nameWithCandidate.getValue();
                    if (!(candidate > min)) continue;
                    classi = (String)nameWithCandidate.getKey();
                    min = candidate;
                }
                if (classi == null) {
                    for (String str : remainingCandidiates.keySet()) {
                        ranking.add(str);
                    }
                    remainingCandidiates.clear();
                    continue;
                }
                ranking.add(classi);
                remainingCandidiates.remove(classi);
            }
            this.rankings.add(new ClassifierRankingForGroup(c.getId(), ranking));
        }
    }

    @Override
    public RankingForGroup<double[], String> getRanking(Instance prob) {
        RankingForGroup myRanking = null;
        double[] point = this.norm.normalize(prob.toDoubleArray());
        L1DistanceMetric dist = new L1DistanceMetric();
        double minDist = Double.MAX_VALUE;
        for (RankingForGroup rankingForGroup : this.rankings) {
            double computedDist = dist.computeDistance((double[])rankingForGroup.getIdentifierForGroup().getIdentifier(), point);
            if (!(computedDist <= minDist)) continue;
            myRanking = rankingForGroup;
            minDist = computedDist;
        }
        return myRanking;
    }

    public List<ClassifierRankingForGroup> getRankings() {
        return this.rankings;
    }
}

