/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.clusterbased.modifiedisac;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.ml.ranking.clusterbased.customdatatypes.ProblemInstance;
import ai.libs.jaicore.ml.ranking.clusterbased.datamanager.IInstanceCollector;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class ModifiedISACInstanceCollector
implements IInstanceCollector<Instance> {
    private ArrayList<ArrayList<Pair<String, Double>>> collectedClassifierandPerformance;
    private int numberOfClassifier;
    private ArrayList<String> allClassifier = new ArrayList();
    private ArrayList<ProblemInstance<Instance>> collectedInstances = new ArrayList();
    private static ArrayList<String> atributesofTrainingsdata = new ArrayList();

    public static List<String> getAtributesofTrainingsdata() {
        return atributesofTrainingsdata;
    }

    public List<ArrayList<Pair<String, Double>>> getCollectedClassifierandPerformance() {
        return this.collectedClassifierandPerformance;
    }

    public int getNumberOfClassifier() {
        return this.numberOfClassifier;
    }

    public List<String> getAllClassifier() {
        return this.allClassifier;
    }

    public ModifiedISACInstanceCollector(Instances data, int startOfClassifierPerformanceValues, int endOfClassifierPerformanceValues) {
        int i;
        this.collectedClassifierandPerformance = new ArrayList();
        this.numberOfClassifier = endOfClassifierPerformanceValues + 1 - (startOfClassifierPerformanceValues + 1) + 1;
        for (Instance i2 : data) {
            ArrayList<Pair> pandc = new ArrayList<Pair>();
            for (int j = endOfClassifierPerformanceValues; j >= startOfClassifierPerformanceValues; --j) {
                String classi = i2.attribute(j).name();
                double perfo = i2.value(j);
                Pair tup = new Pair((Object)classi, (Object)perfo);
                pandc.add(tup);
            }
            this.collectedClassifierandPerformance.add(pandc);
        }
        Instance inst = data.get(0);
        for (i = endOfClassifierPerformanceValues; i >= startOfClassifierPerformanceValues; --i) {
            this.allClassifier.add(inst.attribute(i).name());
            data.deleteAttributeAt(i);
        }
        data.deleteAttributeAt(0);
        for (i = 0; i < data.numAttributes(); ++i) {
            atributesofTrainingsdata.add(data.attribute(i).toString());
        }
        for (Instance i3 : data) {
            this.collectedInstances.add(new ProblemInstance<Instance>(i3));
        }
    }

    private static Instances loadDefaultInstances() throws Exception {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("metaData_smallDataSets_computed.arff");
        ConverterUtils.DataSource source = new ConverterUtils.DataSource(inputStream);
        return source.getDataSet();
    }

    public ModifiedISACInstanceCollector() throws Exception {
        this(ModifiedISACInstanceCollector.loadDefaultInstances(), 104, 125);
    }

    public void setNumberOfClassifier(int number) {
        this.numberOfClassifier = number;
    }

    @Override
    public List<ProblemInstance<Instance>> getProblemInstances() {
        return this.collectedInstances;
    }
}

