/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.classifier;

import ai.libs.jaicore.ml.core.exception.PredictionException;
import ai.libs.jaicore.ml.tsc.classifier.ASimplifiedTSCLearningAlgorithm;
import ai.libs.jaicore.ml.tsc.classifier.ASimplifiedTSClassifier;
import ai.libs.jaicore.ml.tsc.classifier.BOSSClassifier;
import ai.libs.jaicore.ml.tsc.dataset.TimeSeriesDataset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BOSSEnsembleClassifier
extends ASimplifiedTSClassifier<Integer> {
    private ArrayList<BOSSClassifier> ensemble = new ArrayList();

    public BOSSEnsembleClassifier(Map<Integer, Integer> windowLengthsandWordLength, int alphabetSize, double[] alphabet, boolean meanCorrected) {
        for (Map.Entry<Integer, Integer> lengthPair : windowLengthsandWordLength.entrySet()) {
            this.ensemble.add(new BOSSClassifier(lengthPair.getKey(), alphabetSize, alphabet, lengthPair.getValue(), meanCorrected));
        }
    }

    public BOSSEnsembleClassifier(Map<Integer, Integer> windowLengthsandWordLength, double[] alphabet, boolean meanCorrected) {
        this(windowLengthsandWordLength, 4, alphabet, meanCorrected);
    }

    @Override
    public Integer predict(double[] univInstance) throws PredictionException {
        HashMap<Integer, Integer> labelCount = new HashMap<Integer, Integer>();
        int votedLabel = 0;
        int maxNumberOfVotes = Integer.MIN_VALUE;
        for (BOSSClassifier boss : this.ensemble) {
            Integer label = boss.predict(univInstance);
            if (labelCount.containsKey(label)) {
                labelCount.put(label, (Integer)labelCount.get(label) + 1);
                if ((Integer)labelCount.get(label) <= maxNumberOfVotes) continue;
                votedLabel = label;
                maxNumberOfVotes = (Integer)labelCount.get(label);
                continue;
            }
            labelCount.put(label, 1);
            if ((Integer)labelCount.get(label) <= maxNumberOfVotes) continue;
            votedLabel = label;
            maxNumberOfVotes = (Integer)labelCount.get(label);
        }
        return votedLabel;
    }

    @Override
    public Integer predict(List<double[]> multivInstance) throws PredictionException {
        throw new UnsupportedOperationException("The BOSS-Esamble Classifier is an univirate classifier.");
    }

    @Override
    public List<Integer> predict(TimeSeriesDataset dataset) throws PredictionException {
        ArrayList<Integer> predicts = new ArrayList<Integer>();
        for (double[][] matrix : dataset.getValueMatrices()) {
            for (double[] instance : matrix) {
                predicts.add(this.predict(instance));
            }
        }
        return predicts;
    }

    @Override
    public <U extends ASimplifiedTSClassifier<Integer>> ASimplifiedTSCLearningAlgorithm<Integer, U> getLearningAlgorithm(TimeSeriesDataset dataset) {
        throw new UnsupportedOperationException();
    }
}

