/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.distances;

import ai.libs.jaicore.ml.tsc.distances.AWeightedTrigometricDistance;
import ai.libs.jaicore.ml.tsc.distances.ITimeSeriesDistance;
import ai.libs.jaicore.ml.tsc.filter.transform.ATransformFilter;
import ai.libs.jaicore.ml.tsc.filter.transform.CosineTransform;

public class TransformDistance
extends AWeightedTrigometricDistance {
    private ATransformFilter transform;
    private ITimeSeriesDistance timeSeriesDistance;
    private ITimeSeriesDistance baseTransformDistance;

    public TransformDistance(double alpha, ATransformFilter transform, ITimeSeriesDistance timeSeriesDistance, ITimeSeriesDistance transformDistance) {
        super(alpha);
        if (transform == null) {
            throw new IllegalArgumentException("Parameter transform must not be null.");
        }
        if (timeSeriesDistance == null) {
            throw new IllegalArgumentException("Parameter timeSeriesDistance must not be null.");
        }
        if (transformDistance == null) {
            throw new IllegalArgumentException("Parameter transformDistance must not be null.");
        }
        this.transform = transform;
        this.timeSeriesDistance = timeSeriesDistance;
        this.baseTransformDistance = transformDistance;
    }

    public TransformDistance(double alpha, ITimeSeriesDistance timeSeriesDistance, ITimeSeriesDistance transformDistance) {
        this(alpha, new CosineTransform(), timeSeriesDistance, transformDistance);
    }

    public TransformDistance(double alpha, ATransformFilter transform, ITimeSeriesDistance distance) {
        this(alpha, transform, distance, distance);
    }

    public TransformDistance(double alpha, ITimeSeriesDistance distance) {
        this(alpha, new CosineTransform(), distance);
    }

    @Override
    public double distance(double[] a, double[] b) {
        double[] transformA = this.transform.transform(a);
        double[] transformB = this.transform.transform(b);
        return this.getA() * this.timeSeriesDistance.distance(a, b) + this.getB() * this.baseTransformDistance.distance(transformA, transformB);
    }
}

