/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.util;

import java.util.stream.DoubleStream;

public class MathUtil {
    private MathUtil() {
    }

    public static double sigmoid(double z) {
        return 1.0 / (1.0 + Math.exp(-1.0 * z));
    }

    public static double sum(double[] array) {
        return DoubleStream.of(array).sum();
    }

    public static double singleSquaredEuclideanDistance(double[] vector1, double[] vector2) {
        if (vector1.length != vector2.length) {
            throw new IllegalArgumentException("The lengths of of both vectors must match!");
        }
        double distance = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            distance += Math.pow(vector1[i] - vector2[i], 2.0);
        }
        return distance;
    }

    public static double intManhattanDistance(int[] a, int[] b) {
        double result = 0.0;
        for (int j = 0; j < a.length; ++j) {
            result += (double)Math.abs(a[j] - b[j]);
        }
        return result;
    }

    public static double mean(double[] vector, int t1, int t2) {
        MathUtil.checkIntervalParameters(vector, t1, t2);
        double result = 0.0;
        for (int i = t1; i <= t2; ++i) {
            result += vector[i];
        }
        return result / (double)(t2 - t1 + 1);
    }

    public static double stddev(double[] vector, int t1, int t2, boolean useBiasCorrection) {
        MathUtil.checkIntervalParameters(vector, t1, t2);
        if (t1 == t2) {
            return 0.0;
        }
        double mean = MathUtil.mean(vector, t1, t2);
        double result = 0.0;
        for (int i = t1; i <= t2; ++i) {
            result += Math.pow(vector[i] - mean, 2.0);
        }
        return Math.sqrt(result / (double)(t2 - t1 + (useBiasCorrection ? 0 : 1)));
    }

    public static double slope(double[] vector, int t1, int t2) {
        MathUtil.checkIntervalParameters(vector, t1, t2);
        if (t2 == t1) {
            return 0.0;
        }
        double xx = 0.0;
        double x = 0.0;
        double xy = 0.0;
        double y = 0.0;
        for (int i = t1; i <= t2; ++i) {
            x += (double)i;
            y += vector[i];
            xx += (double)(i * i);
            xy += (double)i * vector[i];
        }
        int length = t2 - t1 + 1;
        double denominator = (double)length * xx - x * x;
        if (denominator == 0.0) {
            throw new IllegalArgumentException("Given arguments yield a 0 " + denominator);
        }
        return ((double)length * xy - x * y) / denominator;
    }

    private static void checkIntervalParameters(double[] vector, int t1, int t2) {
        if (t1 >= vector.length || t2 >= vector.length) {
            throw new IllegalArgumentException("Parameters t1 and t2 must be valid indices of the vector!");
        }
        if (t2 < t1) {
            throw new IllegalArgumentException("End index t2 of the interval must be greater equals start index t1!");
        }
    }

    public static int argmax(int[] array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Given parameter 'array' must not be null or empty for argmax.");
        }
        int maxValue = array[0];
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= maxValue) continue;
            maxValue = array[i];
            index = i;
        }
        return index;
    }
}

