package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories;

import java.util.Random;

import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.ILabeledInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol.CaseControlSampling;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.IRerunnableSamplingAlgorithmFactory;

public class CaseControlSamplingFactory<I extends ILabeledInstance<?>, D extends IDataset<I>> implements IRerunnableSamplingAlgorithmFactory<I, D, CaseControlSampling<I, D>> {

	private CaseControlSampling<I, D> previousRun = null;

	@Override
	public void setPreviousRun(final CaseControlSampling<I, D> previousRun) {
		this.previousRun = previousRun;
	}

	@Override
	public CaseControlSampling<I, D> getAlgorithm(final int sampleSize, final D inputDataset, final Random random) {
		CaseControlSampling<I, D> caseControlSampling = new CaseControlSampling<>(random, inputDataset);
		if (this.previousRun != null && this.previousRun.getProbabilityBoundaries() != null) {
			caseControlSampling.setProbabilityBoundaries(this.previousRun.getProbabilityBoundaries());
		}
		caseControlSampling.setSampleSize(sampleSize);
		return caseControlSampling;
	}

}
