/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.cache;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.ml.cache.Instruction;
import ai.libs.jaicore.ml.cache.InstructionGraph;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;

public class InstructionNode
implements Serializable {
    private static final long serialVersionUID = -347708788723924559L;
    private String name;
    private Instruction instruction;
    private List<Pair<String, Integer>> inputs;
    @JsonIgnore
    private InstructionGraph graph;

    public InstructionNode() {
    }

    protected InstructionNode(InstructionGraph graph, @JsonProperty String name, @JsonProperty Instruction instruction) {
        this(graph, name, instruction, null);
    }

    protected InstructionNode(InstructionGraph graph, @JsonProperty String name, @JsonProperty Instruction instruction, @JsonProperty List<Pair<String, Integer>> inputs) {
        this.graph = graph;
        this.name = name;
        this.instruction = instruction;
        this.inputs = inputs;
    }

    public InstructionNode getNodeThatComputesInput(int i) {
        return this.graph.getNodeByName((String)this.inputs.get(i).getX());
    }

    public String getName() {
        return this.name;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public List<Pair<String, Integer>> getInputs() {
        return this.inputs;
    }

    public InstructionGraph getGraph() {
        return this.graph;
    }
}

