/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.cache;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.ml.cache.Instruction;
import ai.libs.jaicore.ml.cache.InstructionFailedException;
import ai.libs.jaicore.ml.cache.InstructionGraph;
import ai.libs.jaicore.ml.cache.LoadDataSetInstructionForARFFFile;
import ai.libs.jaicore.ml.cache.LoadDatasetInstructionForOpenML;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstance;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstances;
import ai.libs.jaicore.ml.openml.OpenMLHelper;
import java.io.File;
import java.util.Arrays;
import weka.core.Instance;
import weka.core.Instances;

public class ReproducibleInstances
extends Instances {
    private static final long serialVersionUID = 4318807226111536282L;
    private InstructionGraph history;
    private Pair<String, Integer> outputUnitOfHistory;
    private boolean cacheStorage = true;
    private boolean cacheLookup = true;

    private ReproducibleInstances(Instances dataset) {
        super(dataset);
    }

    public ReproducibleInstances(ReproducibleInstances dataset) {
        this((Instances)dataset);
        this.history = new InstructionGraph(dataset.history);
        this.outputUnitOfHistory = new Pair(dataset.outputUnitOfHistory.getX(), dataset.outputUnitOfHistory.getY());
        this.cacheLookup = dataset.cacheLookup;
        this.cacheStorage = dataset.cacheStorage;
    }

    public static ReproducibleInstances fromHistory(InstructionGraph history, Pair<String, Integer> outputUnitOfHistory) throws InstructionFailedException, InterruptedException {
        ReproducibleInstances result = new ReproducibleInstances((Instances)((WekaInstances)history.getDataForUnit(outputUnitOfHistory)).getList());
        result.history = history;
        result.outputUnitOfHistory = outputUnitOfHistory;
        result.cacheLookup = true;
        result.cacheStorage = true;
        return result;
    }

    public static ReproducibleInstances fromOpenML(int id, String apiKey) throws InstructionFailedException, InterruptedException {
        OpenMLHelper.setApiKey(apiKey);
        InstructionGraph graph = new InstructionGraph();
        graph.addNode("load", new LoadDatasetInstructionForOpenML(apiKey, id));
        Pair outputUnit = new Pair((Object)"load", (Object)0);
        ReproducibleInstances result = new ReproducibleInstances((Instances)((WekaInstances)graph.getDataForUnit((Pair<String, Integer>)outputUnit)).getList());
        result.history = graph;
        result.outputUnitOfHistory = outputUnit;
        result.cacheLookup = true;
        result.cacheStorage = true;
        return result;
    }

    public static ReproducibleInstances fromARFF(File arffFile) throws InstructionFailedException, InterruptedException {
        InstructionGraph graph = new InstructionGraph();
        graph.addNode("load", new LoadDataSetInstructionForARFFFile(arffFile));
        Pair outputUnit = new Pair((Object)"load", (Object)0);
        ReproducibleInstances result = new ReproducibleInstances((Instances)((WekaInstances)graph.getDataForUnit((Pair<String, Integer>)outputUnit)).getList());
        result.history = graph;
        result.outputUnitOfHistory = outputUnit;
        result.cacheLookup = true;
        result.cacheStorage = true;
        return result;
    }

    public InstructionGraph getInstructions() {
        if (this.cacheLookup || this.cacheStorage) {
            return this.history;
        }
        return null;
    }

    public Pair<String, Integer> getOutputUnit() {
        return this.outputUnitOfHistory;
    }

    public void setOutputUnitWithoutRecomputation(Pair<String, Integer> outputUnit) {
        this.outputUnitOfHistory = outputUnit;
    }

    public boolean isCacheStorage() {
        return this.cacheStorage;
    }

    public void setCacheStorage(boolean cacheStorage) {
        this.cacheStorage = cacheStorage;
    }

    public boolean isCacheLookup() {
        return this.cacheLookup;
    }

    public void setCacheLookup(boolean cacheLookup) {
        this.cacheLookup = cacheLookup;
    }

    public ReproducibleInstances reduceWithInstruction(String nameOfRefinementInstruction, Instruction instruction, int outputOfRefinementInstruction) throws ClassNotFoundException, InstructionFailedException, InterruptedException {
        this.history.addNode(nameOfRefinementInstruction, instruction, Arrays.asList(this.getOutputUnit()));
        this.outputUnitOfHistory = new Pair((Object)nameOfRefinementInstruction, (Object)outputOfRefinementInstruction);
        WekaInstances remainingData = (WekaInstances)instruction.getOutputInstances(Arrays.asList(new WekaInstances(this))).get(outputOfRefinementInstruction);
        this.removeIf(i -> !remainingData.contains(new WekaInstance((Instance)i)));
        return this;
    }
}

