/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core;

import ai.libs.jaicore.logging.LoggerUtil;
import ai.libs.jaicore.ml.interfaces.Instance;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleInstanceImpl
extends ArrayList<Double>
implements Instance {
    private static final Logger logger = LoggerFactory.getLogger(SimpleInstanceImpl.class);

    public SimpleInstanceImpl() {
    }

    public SimpleInstanceImpl(int initialCapacity) {
        super(initialCapacity);
    }

    public SimpleInstanceImpl(Collection<Double> values) {
        super(values);
    }

    public SimpleInstanceImpl(double[] values) {
        super(values.length);
        for (int i = 0; i < values.length; ++i) {
            super.add(i, values[i]);
        }
    }

    public SimpleInstanceImpl(String json) throws IOException {
        this(new ObjectMapper().readTree(json));
    }

    public SimpleInstanceImpl(JsonNode jsonNode) {
        this();
        for (JsonNode val : jsonNode) {
            this.add(val.asDouble());
        }
    }

    @Override
    public String toJson() {
        ObjectMapper om = new ObjectMapper();
        try {
            return om.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            logger.error(LoggerUtil.getExceptionInfo((Throwable)e));
            return null;
        }
    }

    @Override
    public int getNumberOfColumns() {
        return this.size();
    }
}

