/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset;

import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IOrderedLabeledAttributeArrayDataset;
import ai.libs.jaicore.ml.core.dataset.TimeSeriesInstance;
import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeType;
import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.timeseries.TimeSeriesAttributeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.nd4j.linalg.api.ndarray.INDArray;

public class TimeSeriesDataset<L>
implements IOrderedLabeledAttributeArrayDataset<TimeSeriesInstance<L>, L> {
    private long numberOfInstances;
    private List<INDArray> valueMatrices;
    private List<INDArray> timestampMatrices;
    private INDArray targets;
    private final IAttributeType<L> targetType;
    private List<IAttributeType<?>> attributeTypes;

    public TimeSeriesDataset(List<INDArray> valueMatrices, List<INDArray> timestampMatrices, INDArray targets, IAttributeType<L> targetType) {
        this.numberOfInstances = valueMatrices.get(0).shape()[0];
        this.valueMatrices = valueMatrices;
        this.timestampMatrices = timestampMatrices;
        this.targets = targets;
        this.attributeTypes = new ArrayList();
        for (INDArray valueMatrix : valueMatrices) {
            this.addAttributeType(valueMatrix);
        }
        this.targetType = targetType;
    }

    public void add(INDArray valueMatrix, INDArray timestampMatrix) {
        this.valueMatrices.add(valueMatrix);
        this.timestampMatrices.add(timestampMatrix);
        this.addAttributeType(valueMatrix);
    }

    @Override
    public TimeSeriesInstance<L> remove(int index) {
        Object instance = this.get(index);
        this.valueMatrices.remove(index);
        this.timestampMatrices.remove(index);
        this.attributeTypes.remove(index);
        return instance;
    }

    public void replace(int index, INDArray valueMatrix, INDArray timestampMatrix) {
        this.valueMatrices.set(index, valueMatrix);
        if (timestampMatrix != null && this.timestampMatrices != null && this.timestampMatrices.size() > index) {
            this.timestampMatrices.set(index, timestampMatrix);
        }
        TimeSeriesAttributeType type = this.createAttributeType(valueMatrix);
        this.attributeTypes.set(index, type);
    }

    public INDArray getTargets() {
        return this.targets;
    }

    public int getNumberOfVariables() {
        return this.valueMatrices.size();
    }

    public long getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public INDArray getValues(int index) {
        return this.valueMatrices.get(index);
    }

    public INDArray getTimestamps(int index) {
        return this.timestampMatrices.get(index);
    }

    public INDArray getValuesOrNull(int index) {
        return this.valueMatrices.size() > index ? this.valueMatrices.get(index) : null;
    }

    public INDArray getTimestampsOrNull(int index) {
        return this.timestampMatrices != null && this.timestampMatrices.size() > index ? this.timestampMatrices.get(index) : null;
    }

    @Override
    public boolean isEmpty() {
        return this.valueMatrices.isEmpty();
    }

    public boolean isUnivariate() {
        return this.valueMatrices.size() == 1;
    }

    public boolean isMultivariate() {
        return this.valueMatrices.size() > 1;
    }

    private TimeSeriesAttributeType createAttributeType(INDArray valueMatrix) {
        int length = (int)valueMatrix.shape()[1];
        return new TimeSeriesAttributeType(length);
    }

    private void addAttributeType(INDArray valueMatrix) {
        TimeSeriesAttributeType type = this.createAttributeType(valueMatrix);
        this.attributeTypes.add(type);
    }

    @Override
    public TimeSeriesInstance<L> get(int index) {
        ArrayList attributeValues = new ArrayList();
        for (int i = 0; i < this.valueMatrices.size(); ++i) {
            INDArray viewOnCurrent = this.valueMatrices.get(i).getRow((long)index);
            IAttributeType<?> type = this.attributeTypes.get(i);
            IAttributeValue<?> value = type.buildAttributeValue(viewOnCurrent);
            attributeValues.add(value);
        }
        double target = this.targets.getDouble((long)index);
        return new TimeSeriesInstance<L>(attributeValues, this.targetType.buildAttributeValue(target).getValue());
    }

    @Override
    public Iterator<TimeSeriesInstance<L>> iterator() {
        return new TimeSeriesDatasetIterator();
    }

    @Override
    public int getNumberOfAttributes() {
        return this.attributeTypes.size();
    }

    @Override
    public List<IAttributeType<?>> getAttributeTypes() {
        return this.attributeTypes;
    }

    @Override
    public IAttributeType<L> getTargetType() {
        return this.targetType;
    }

    @Override
    public IDataset<TimeSeriesInstance<L>> createEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(TimeSeriesInstance<L> e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends TimeSeriesInstance<L>> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int arg0, TimeSeriesInstance<L> arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends TimeSeriesInstance<L>> arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<TimeSeriesInstance<L>> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<TimeSeriesInstance<L>> listIterator(int arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TimeSeriesInstance<L> set(int arg0, TimeSeriesInstance<L> arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TimeSeriesInstance<L>> subList(int arg0, int arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFrequency(TimeSeriesInstance<L> instance) {
        return (int)this.stream().filter(instance::equals).count();
    }

    class TimeSeriesDatasetIterator
    implements Iterator<TimeSeriesInstance<L>> {
        private int current = 0;

        TimeSeriesDatasetIterator() {
        }

        @Override
        public boolean hasNext() {
            return TimeSeriesDataset.this.numberOfInstances > (long)this.current;
        }

        @Override
        public TimeSeriesInstance<L> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return TimeSeriesDataset.this.get(this.current++);
        }
    }
}

