/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.attribute.categorical;

import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.categorical.CategoricalAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.categorical.ICategoricalAttributeType;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class CategoricalAttributeType
implements ICategoricalAttributeType {
    private static final long serialVersionUID = -1258014436188830057L;
    private final List<String> domain;

    public CategoricalAttributeType(List<String> domain) {
        if (new HashSet<String>(domain).size() != domain.size()) {
            throw new IllegalArgumentException("Domain contains duplicate values");
        }
        this.domain = new LinkedList<String>(domain);
    }

    @Override
    public List<String> getDomain() {
        return this.domain;
    }

    @Override
    public boolean isValidValue(String value) {
        return this.domain.contains(value);
    }

    @Override
    public IAttributeValue<String> buildAttributeValue(Object value) {
        return this.buildAttributeValue(value.toString());
    }

    @Override
    public IAttributeValue<String> buildAttributeValue(String stringDescription) {
        return new CategoricalAttributeValue(this, stringDescription);
    }

    public String toString() {
        return "CAT:" + this.domain.toString();
    }

    @Override
    public String getStringDescriptionOfDomain() {
        return this.domain.toString();
    }
}

