/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.attribute.transformer.multivalue;

import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.multivalue.MultiValueAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.transformer.ISingleAttributeTransformer;
import ai.libs.jaicore.ml.core.dataset.attribute.transformer.multivalue.MultiValueBinaryzationTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class MinHashingTransformer
implements ISingleAttributeTransformer {
    private int[][] permutations;

    public MinHashingTransformer(int[][] permutations) {
        this.permutations = permutations;
    }

    public MinHashingTransformer(int domainSize, int signatureLength, long seed) {
        this.permutations = new int[signatureLength][domainSize];
        Random random = new Random(seed);
        for (int i = 0; i < signatureLength; ++i) {
            int p;
            ArrayList<Integer> permutation = new ArrayList<Integer>(domainSize);
            for (p = 0; p < domainSize; ++p) {
                permutation.add(p);
            }
            Collections.shuffle(permutation, random);
            for (p = 0; p < domainSize; ++p) {
                this.permutations[i][p] = (Integer)permutation.get(p);
            }
        }
    }

    @Override
    public double[] transformAttribute(IAttributeValue<?> attributeToTransform) {
        if (!(attributeToTransform instanceof MultiValueAttributeValue)) {
            throw new IllegalArgumentException("Can only perform Multi-Value Binaryzation for multi-value attributes.");
        }
        MultiValueBinaryzationTransformer binaryzationTransformer = new MultiValueBinaryzationTransformer();
        double[] binaryzation = binaryzationTransformer.transformAttribute(attributeToTransform);
        double[] signature = new double[this.permutations.length];
        for (int i = 0; i < this.permutations.length; ++i) {
            int signatureElement = 0;
            for (int p = 0; p < this.permutations[i].length; ++p) {
                if (binaryzation[this.permutations[i][p]] != 1.0) continue;
                signatureElement = p + 1;
                break;
            }
            signature[i] = signatureElement;
        }
        return signature;
    }
}

