/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.infiles;

import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.EAlgorithmState;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.ml.core.dataset.ArffUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AFileSamplingAlgorithm
extends AAlgorithm<File, File> {
    private static final Logger LOG = LoggerFactory.getLogger(AFileSamplingAlgorithm.class);
    protected Integer sampleSize = null;
    private String outputFilePath = null;
    protected FileWriter outputFileWriter;

    protected AFileSamplingAlgorithm(File input) {
        super((Object)input);
    }

    public void setSampleSize(int size) {
        this.sampleSize = size;
    }

    public void setOutputFileName(String outputFilePath) throws IOException {
        this.outputFilePath = outputFilePath;
        this.outputFileWriter = new FileWriter(outputFilePath);
    }

    public File call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmException {
        Instant timeoutTime = null;
        if (this.getTimeout().milliseconds() <= 0L) {
            LOG.debug("Invalid or no timeout set. There will be no timeout in this algorithm run");
            timeoutTime = Instant.MAX;
        } else {
            timeoutTime = Instant.now().plus(this.getTimeout().milliseconds(), ChronoUnit.MILLIS);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set timeout to {}", (Object)timeoutTime);
            }
        }
        if (this.outputFilePath == null || this.outputFilePath.length() == 0) {
            throw new AlgorithmException("No output file path specified");
        }
        if (this.sampleSize == null) {
            throw new AlgorithmException("No valid sample size specified");
        }
        File dataset = (File)this.getInput();
        if (dataset == null || !dataset.exists() || !dataset.isFile()) {
            throw new AlgorithmException("No dataset file or an invalid dataset file was given as an input.");
        }
        try {
            this.outputFileWriter.write(ArffUtilities.extractArffHeader((File)this.getInput()));
        }
        catch (IOException e) {
            throw new AlgorithmException((Throwable)e, "Error while writing to given output path.");
        }
        if (this.sampleSize == 0) {
            LOG.warn("Sample size is 0, so an empty data set is returned!");
            return new File(this.outputFilePath);
        }
        this.setState(EAlgorithmState.CREATED);
        while (this.hasNext()) {
            try {
                this.checkAndConductTermination();
            }
            catch (AlgorithmTimeoutedException e) {
                this.cleanUp();
                throw new AlgorithmException(e.getMessage());
            }
            if (Instant.now().isAfter(timeoutTime)) {
                LOG.warn("Algorithm is running even though it has been timeouted. Cancelling..");
                this.cancel();
                throw new AlgorithmException("Algorithm is running even though it has been timeouted");
            }
            this.next();
        }
        try {
            this.outputFileWriter.flush();
            this.outputFileWriter.close();
        }
        catch (IOException e) {
            this.cleanUp();
            throw new AlgorithmException((Throwable)e, "Could not close File writer for sampling output file");
        }
        this.cleanUp();
        return new File(this.outputFilePath);
    }

    protected abstract void cleanUp();
}

