/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories;

import ai.libs.jaicore.ml.core.dataset.INumericArrayInstance;
import ai.libs.jaicore.ml.core.dataset.IOrderedDataset;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.SystematicSampling;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.IRerunnableSamplingAlgorithmFactory;
import java.util.Comparator;
import java.util.Random;

public class SystematicSamplingFactory<I extends INumericArrayInstance, D extends IOrderedDataset<I>>
implements IRerunnableSamplingAlgorithmFactory<I, D, SystematicSampling<I, D>> {
    private Comparator<I> datapointComparator = null;
    private SystematicSampling<I, D> previousRun = null;

    public void setDatapointComparator(Comparator<I> datapointComparator) {
        this.datapointComparator = datapointComparator;
    }

    @Override
    public void setPreviousRun(SystematicSampling<I, D> previousRun) {
        this.previousRun = previousRun;
    }

    @Override
    public SystematicSampling<I, D> getAlgorithm(int sampleSize, D inputDataset, Random random) {
        SystematicSampling systematicSampling = this.datapointComparator != null ? new SystematicSampling<I, D>(random, this.datapointComparator, inputDataset) : new SystematicSampling(random, inputDataset);
        systematicSampling.setSampleSize(sampleSize);
        if (this.previousRun != null && this.previousRun.getSortedDataset() != null) {
            systematicSampling.setSortedDataset(this.previousRun.getSortedDataset());
        }
        return systematicSampling;
    }
}

