/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.measure.multilabel;

import ai.libs.jaicore.ml.core.evaluation.measure.multilabel.ADecomposableMultilabelMeasure;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import meka.core.Metrics;

public class InstanceWiseF1
extends ADecomposableMultilabelMeasure {
    @Override
    public Double calculateMeasure(double[] actual, double[] expected) {
        if (actual.length != expected.length) {
            throw new IllegalArgumentException("Actual and Expected must be of the same length.");
        }
        int predictedAndExpectedSum = Arrays.stream(actual).mapToInt(x -> (int)x).sum() + Arrays.stream(expected).mapToInt(x -> (int)x).sum();
        if (predictedAndExpectedSum == 0) {
            return 0.0;
        }
        int intersection = IntStream.range(0, actual.length).filter(x -> actual[x] == 1.0 && expected[x] == 1.0).map(x -> 1).sum();
        return 2.0 * (double)intersection / (double)predictedAndExpectedSum;
    }

    @Override
    public Double calculateAvgMeasure(List<double[]> actual, List<double[]> expected) {
        double[][] ypred = new double[actual.size()][];
        int[][] ypredint = new int[actual.size()][];
        for (int i = 0; i < actual.size(); ++i) {
            ypred[i] = actual.get(i);
            ypredint[i] = Arrays.stream(actual.get(i)).mapToInt(x -> x >= 0.5 ? 1 : 0).toArray();
        }
        int[][] y = new int[expected.size()][];
        for (int i = 0; i < expected.size(); ++i) {
            y[i] = Arrays.stream(expected.get(i)).mapToInt(x -> x >= 0.5 ? 1 : 0).toArray();
        }
        return Metrics.P_FmacroAvgD((int[][])y, (int[][])ypredint);
    }
}

