/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.measure.multilabel;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.ml.core.evaluation.measure.ADecomposableDoubleMeasure;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import meka.core.Metrics;

public class RankLoss
extends ADecomposableDoubleMeasure<double[]> {
    @Override
    public Double calculateMeasure(double[] actual, double[] expected) {
        int numLabels = actual.length;
        List labelPairs = SetUtil.getAllPossibleSubsetsWithSize((Collection)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(numLabels - 1)), (DiscreteDomain)DiscreteDomain.integers()).asList(), (int)2);
        int mistakes = 0;
        int differentPairs = 0;
        for (Set pair : labelPairs) {
            Iterator it = pair.iterator();
            int x = (Integer)it.next();
            int y = (Integer)it.next();
            double xProb = expected[x];
            double yProb = expected[y];
            double xTrue = actual[x];
            double yTrue = actual[y];
            if (xTrue == yTrue) continue;
            ++differentPairs;
            if (xProb == yProb) {
                mistakes = (int)((double)mistakes + 0.5);
                continue;
            }
            if (xTrue == 1.0 && xProb < yProb) {
                ++mistakes;
                continue;
            }
            if (yTrue != 1.0 || !(yProb < xProb)) continue;
            ++mistakes;
        }
        if (differentPairs == 0) {
            return Double.NaN;
        }
        return (double)mistakes / (double)differentPairs;
    }

    @Override
    public Double calculateAvgMeasure(List<double[]> actual, List<double[]> expected) {
        double[][] ypred = new double[actual.size()][];
        int[][] ypredint = new int[actual.size()][];
        for (int i = 0; i < actual.size(); ++i) {
            ypred[i] = actual.get(i);
            ypredint[i] = Arrays.stream(actual.get(i)).mapToInt(x -> x >= 0.5 ? 1 : 0).toArray();
        }
        int[][] y = new int[expected.size()][];
        for (int i = 0; i < expected.size(); ++i) {
            y[i] = Arrays.stream(expected.get(i)).mapToInt(x -> x >= 0.5 ? 1 : 0).toArray();
        }
        return Metrics.L_RankLoss((int[][])y, (double[][])ypred);
    }
}

