/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.dyadranking;

import ai.libs.jaicore.math.linearalgebra.Vector;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class Dyad {
    private Vector instance;
    private Vector alternative;

    public Dyad(Vector instance, Vector alternative) {
        this.instance = instance;
        this.alternative = alternative;
    }

    public Vector getInstance() {
        return this.instance;
    }

    public Vector getAlternative() {
        return this.alternative;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Dyad (");
        builder.append("instance (");
        builder.append(this.instance);
        builder.append(")");
        builder.append("alternative (");
        builder.append(this.alternative);
        builder.append(")");
        builder.append(")");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Dyad)) {
            return false;
        }
        Dyad other = (Dyad)o;
        if (this.instance != null && other.instance != null && this.alternative != null && other.alternative != null && other.instance.equals(this.instance) && other.alternative.equals(this.alternative)) {
            return this.instance.equals(other.instance) && this.alternative.equals(other.alternative);
        }
        return this.instance == null && other.instance == null && this.alternative == null && other.alternative == null;
    }

    public int hashCode() {
        int result = 42;
        result = result * 31 + this.instance.hashCode();
        result = result * 31 + this.alternative.hashCode();
        return result;
    }

    public INDArray toVector() {
        INDArray instanceOfDyad = Nd4j.create((double[])this.getInstance().asArray());
        INDArray alternativeOfDyad = Nd4j.create((double[])this.getAlternative().asArray());
        return Nd4j.hstack((INDArray[])new INDArray[]{instanceOfDyad, alternativeOfDyad});
    }
}

