/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.dyadranking.dataset;

import ai.libs.jaicore.math.linearalgebra.Vector;
import ai.libs.jaicore.ml.core.dataset.ContainsNonNumericAttributesException;
import ai.libs.jaicore.ml.core.dataset.INumericArrayInstance;
import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.primitive.NumericAttributeType;
import ai.libs.jaicore.ml.core.dataset.attribute.primitive.NumericAttributeValue;
import ai.libs.jaicore.ml.dyadranking.Dyad;
import ai.libs.jaicore.ml.dyadranking.dataset.ADyadRankingInstance;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SparseDyadRankingInstance
extends ADyadRankingInstance
implements INumericArrayInstance {
    private Vector instance;
    private List<Vector> alternatives;

    public SparseDyadRankingInstance(Vector instance, List<Vector> alternatives) {
        this.instance = instance;
        this.alternatives = Collections.unmodifiableList(alternatives);
    }

    @Override
    public <T> IAttributeValue<T> getAttributeValueAtPosition(int position, Class<T> type) {
        if (type.equals(Double.class)) {
            return this.getAttributeValue(position);
        }
        throw new IllegalArgumentException("Sparse dyad ranking instances only have attributes of type double.");
    }

    @Override
    public SparseDyadRankingInstance getTargetValue() {
        return this;
    }

    @Override
    public double[] getAsDoubleVector() throws ContainsNonNumericAttributesException {
        throw new UnsupportedOperationException("Sparse dyad ranking instances cannot be converted to a double vector since the target type is an ordering of dyads.");
    }

    @Override
    public Iterator<Dyad> iterator() {
        return new Iterator<Dyad>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < SparseDyadRankingInstance.this.alternatives.size();
            }

            @Override
            public Dyad next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SparseDyadRankingInstance.this.getDyadAtPosition(this.index++);
            }
        };
    }

    @Override
    public Dyad getDyadAtPosition(int position) {
        return new Dyad(this.instance, this.alternatives.get(position));
    }

    @Override
    public int length() {
        return this.alternatives.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SparseDyadRankingInstance: ");
        builder.append(System.lineSeparator());
        builder.append("Instance: ");
        builder.append(this.instance);
        builder.append(System.lineSeparator());
        builder.append("Alternatives: ");
        builder.append(this.alternatives);
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alternatives == null ? 0 : this.alternatives.hashCode());
        result = 31 * result + (this.instance == null ? 0 : this.instance.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparseDyadRankingInstance other = (SparseDyadRankingInstance)obj;
        if (this.alternatives == null ? other.alternatives != null : !this.alternatives.equals(other.alternatives)) {
            return false;
        }
        return !(this.instance == null ? other.instance != null : !this.instance.equals(other.instance));
    }

    @Override
    public IAttributeValue<?>[] getAllAttributeValues() {
        throw new UnsupportedOperationException("Currently not implemented!");
    }

    @Override
    public int getNumberOfAttributes() {
        return this.instance.length();
    }

    @Override
    public IAttributeValue<Double> getAttributeValue(int position) {
        return new NumericAttributeValue(new NumericAttributeType(), this.instance.getValue(position));
    }
}

