/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.dyadranking.optimizing;

import ai.libs.jaicore.math.linearalgebra.DenseDoubleVector;
import ai.libs.jaicore.math.linearalgebra.Vector;
import ai.libs.jaicore.ml.dyadranking.Dyad;
import ai.libs.jaicore.ml.dyadranking.dataset.DyadRankingDataset;
import ai.libs.jaicore.ml.dyadranking.dataset.IDyadRankingInstance;
import ai.libs.jaicore.ml.dyadranking.optimizing.DyadRankingFeatureTransformNegativeLogLikelihood;
import ai.libs.jaicore.ml.dyadranking.optimizing.DyadRankingFeatureTransformNegativeLogLikelihoodDerivative;
import edu.stanford.nlp.optimization.DiffFunction;
import java.util.Map;

public class BilinFunction
implements DiffFunction {
    private DyadRankingFeatureTransformNegativeLogLikelihood function = new DyadRankingFeatureTransformNegativeLogLikelihood();
    private DyadRankingFeatureTransformNegativeLogLikelihoodDerivative gradient;
    private int dimension;

    public BilinFunction(Map<IDyadRankingInstance, Map<Dyad, Vector>> featureTransforms, DyadRankingDataset drDataset, int dimension) {
        this.function.initialize(drDataset, featureTransforms);
        this.gradient = new DyadRankingFeatureTransformNegativeLogLikelihoodDerivative();
        this.gradient.initialize(drDataset, featureTransforms);
        this.dimension = dimension;
    }

    public double valueAt(double[] x) {
        return this.function.apply((Vector)new DenseDoubleVector(x));
    }

    public int domainDimension() {
        return this.dimension;
    }

    public double[] derivativeAt(double[] x) {
        return this.gradient.apply((Vector)new DenseDoubleVector(x)).asArray();
    }
}

