/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.dyadranking.search;

import ai.libs.jaicore.search.model.travesaltree.Node;
import java.util.LinkedList;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomlyRankedNodeQueue<N, V extends Comparable<V>>
extends LinkedList<Node<N, V>> {
    private Random random;
    private transient Logger logger = LoggerFactory.getLogger(RandomlyRankedNodeQueue.class);

    public RandomlyRankedNodeQueue(int seed) {
        this.random = new Random(seed);
    }

    @Override
    public boolean add(Node<N, V> e) {
        int position = this.random.nextInt(this.size() + 1);
        this.logger.debug("Add node at random position {} to OPEN list of size {}.", (Object)position, (Object)this.size());
        super.add(position, e);
        return true;
    }

    @Override
    public void add(int position, Node<N, V> e) {
        throw new UnsupportedOperationException("Cannot place items at a specific position wihtin a randomly ranked queue!");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.random == null ? 0 : this.random.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RandomlyRankedNodeQueue other = (RandomlyRankedNodeQueue)obj;
        return !(this.random == null ? other.random != null : !this.random.equals(other.random));
    }
}

