/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.dyadranking.util;

import ai.libs.jaicore.math.linearalgebra.Vector;
import ai.libs.jaicore.ml.dyadranking.Dyad;
import ai.libs.jaicore.ml.dyadranking.dataset.DyadRankingDataset;
import ai.libs.jaicore.ml.dyadranking.dataset.DyadRankingInstance;
import ai.libs.jaicore.ml.dyadranking.dataset.IDyadRankingInstance;
import ai.libs.jaicore.ml.dyadranking.dataset.SparseDyadRankingInstance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public abstract class AbstractDyadScaler
implements Serializable {
    private static final long serialVersionUID = -825893010030419116L;
    protected SummaryStatistics[] statsX;
    protected SummaryStatistics[] statsY;

    public SummaryStatistics[] getStatsX() {
        return this.statsX;
    }

    public SummaryStatistics[] getStatsY() {
        return this.statsY;
    }

    public void fit(DyadRankingDataset dataset) {
        int i;
        int lengthX = ((IDyadRankingInstance)dataset.get(0)).getDyadAtPosition(0).getInstance().length();
        int lengthY = ((IDyadRankingInstance)dataset.get(0)).getDyadAtPosition(0).getAlternative().length();
        this.statsX = new SummaryStatistics[lengthX];
        this.statsY = new SummaryStatistics[lengthY];
        for (i = 0; i < lengthX; ++i) {
            this.statsX[i] = new SummaryStatistics();
        }
        for (i = 0; i < lengthY; ++i) {
            this.statsY[i] = new SummaryStatistics();
        }
        for (IDyadRankingInstance instance : dataset) {
            for (Dyad dyad : instance) {
                int i2;
                for (i2 = 0; i2 < lengthX; ++i2) {
                    this.statsX[i2].addValue(dyad.getInstance().getValue(i2));
                }
                for (i2 = 0; i2 < lengthY; ++i2) {
                    this.statsY[i2].addValue(dyad.getAlternative().getValue(i2));
                }
            }
        }
    }

    public void transform(DyadRankingDataset dataset) {
        int lengthX = ((IDyadRankingInstance)dataset.get(0)).getDyadAtPosition(0).getInstance().length();
        int lengthY = ((IDyadRankingInstance)dataset.get(0)).getDyadAtPosition(0).getAlternative().length();
        if (lengthX != this.statsX.length || lengthY != this.statsY.length) {
            throw new IllegalArgumentException("The scaler was fit to dyads with instances of length " + this.statsX.length + " and alternatives of length " + this.statsY.length + "\n but received instances of length " + lengthX + " and alternatives of length " + lengthY);
        }
        this.transformInstances(dataset);
        this.transformAlternatives(dataset);
    }

    public void transformInstances(DyadRankingDataset dataset) {
        this.transformInstances(dataset, new ArrayList<Integer>());
    }

    public void transformAlternatives(DyadRankingDataset dataset) {
        this.transformAlternatives(dataset, new ArrayList<Integer>());
    }

    public abstract void transformInstances(Dyad var1, List<Integer> var2);

    public abstract void transformAlternatives(Dyad var1, List<Integer> var2);

    public abstract void transformInstaceVector(Vector var1, List<Integer> var2);

    public void transformInstances(SparseDyadRankingInstance drInstance, List<Integer> ignoredIndices) {
        this.transformInstaceVector(drInstance.getDyadAtPosition(0).getInstance(), ignoredIndices);
    }

    public void transformInstances(DyadRankingInstance drInstance, List<Integer> ignoredIndices) {
        for (Dyad dyad : drInstance) {
            this.transformInstances(dyad, ignoredIndices);
        }
    }

    public void transformAlternatives(IDyadRankingInstance drInstance, List<Integer> ignoredIndices) {
        for (Dyad dyad : drInstance) {
            this.transformAlternatives(dyad, ignoredIndices);
        }
    }

    public void transformInstances(DyadRankingDataset dataset, List<Integer> ignoredIndices) {
        for (IDyadRankingInstance instance : dataset) {
            if (instance instanceof SparseDyadRankingInstance) {
                SparseDyadRankingInstance drSparseInstance = (SparseDyadRankingInstance)instance;
                this.transformInstances(drSparseInstance, ignoredIndices);
                continue;
            }
            if (instance instanceof DyadRankingInstance) {
                DyadRankingInstance drDenseInstance = (DyadRankingInstance)instance;
                this.transformInstances(drDenseInstance, ignoredIndices);
                continue;
            }
            throw new IllegalArgumentException("The scalers only support SparseDyadRankingInstance and DyadRankingInstance!");
        }
    }

    public void transformAlternatives(DyadRankingDataset dataset, List<Integer> ignoredIndices) {
        for (IDyadRankingInstance instance : dataset) {
            this.transformAlternatives(instance, ignoredIndices);
        }
    }

    public void fitTransform(DyadRankingDataset dataset) {
        this.fit(dataset);
        this.transform(dataset);
    }

    public String getPrettySTDString() {
        if (this.statsX == null || this.statsY == null) {
            throw new IllegalStateException("The scaler must be fit before calling this method!");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Standard deviations for instances: ");
        for (SummaryStatistics stats : this.statsX) {
            builder.append(stats.getStandardDeviation());
            builder.append(", ");
        }
        builder.append(System.lineSeparator());
        builder.append("Standard deviations for alternatives: ");
        for (SummaryStatistics stats : this.statsY) {
            builder.append(stats.getStandardDeviation());
            builder.append(", ");
        }
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    public String getPrettyMeansString() {
        if (this.statsX == null || this.statsY == null) {
            throw new IllegalStateException("The scaler must be fit before calling this method!");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Means for instances: ");
        for (SummaryStatistics stats : this.statsX) {
            builder.append(stats.getMean());
            builder.append(", ");
        }
        builder.append(System.lineSeparator());
        builder.append("Means for alternatives: ");
        for (SummaryStatistics stats : this.statsY) {
            builder.append(stats.getMean());
            builder.append(", ");
        }
        builder.append(System.lineSeparator());
        return builder.toString();
    }
}

