/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.dyadranking.util;

import ai.libs.jaicore.math.linearalgebra.Vector;
import ai.libs.jaicore.ml.dyadranking.Dyad;
import ai.libs.jaicore.ml.dyadranking.dataset.DyadRankingDataset;
import ai.libs.jaicore.ml.dyadranking.dataset.IDyadRankingInstance;
import ai.libs.jaicore.ml.dyadranking.util.AbstractDyadScaler;
import java.util.List;

public class DyadUnitIntervalScaler
extends AbstractDyadScaler {
    private double[] lengthOfX;
    private double[] lengthOfY;
    private static final long serialVersionUID = -6732663643697649308L;

    @Override
    public void fit(DyadRankingDataset dataset) {
        super.fit(dataset);
        int lengthX = ((IDyadRankingInstance)dataset.get(0)).getDyadAtPosition(0).getInstance().length();
        this.lengthOfX = new double[lengthX];
        for (int i = 0; i < lengthX; ++i) {
            this.lengthOfX[i] = Math.sqrt(this.statsX[i].getSumsq());
        }
        int lengthY = ((IDyadRankingInstance)dataset.get(0)).getDyadAtPosition(0).getAlternative().length();
        this.lengthOfY = new double[lengthY];
        for (int i = 0; i < lengthY; ++i) {
            this.lengthOfY[i] = Math.sqrt(this.statsY[i].getSumsq());
        }
    }

    @Override
    public void transformInstances(DyadRankingDataset dataset, List<Integer> ignoredIndices) {
        int lengthX = ((IDyadRankingInstance)dataset.get(0)).getDyadAtPosition(0).getInstance().length();
        for (IDyadRankingInstance instance : dataset) {
            for (Dyad dyad : instance) {
                for (int i = 0; i < lengthX; ++i) {
                    double value = dyad.getInstance().getValue(i);
                    if (value != 0.0) {
                        value /= this.lengthOfX[i];
                    }
                    dyad.getInstance().setValue(i, value);
                }
            }
        }
    }

    @Override
    public void transformAlternatives(DyadRankingDataset dataset, List<Integer> ignoredIndices) {
        int lengthY = ((IDyadRankingInstance)dataset.get(0)).getDyadAtPosition(0).getAlternative().length();
        for (IDyadRankingInstance instance : dataset) {
            for (Dyad dyad : instance) {
                for (int i = 0; i < lengthY; ++i) {
                    double value = dyad.getAlternative().getValue(i);
                    if (value != 0.0) {
                        value /= this.lengthOfY[i];
                    }
                    dyad.getAlternative().setValue(i, value);
                }
            }
        }
    }

    @Override
    public void transformInstaceVector(Vector vector, List<Integer> ignoredIndices) {
        for (int i = 0; i < vector.length(); ++i) {
            if (ignoredIndices.contains(i)) continue;
            double value = vector.getValue(i);
            if (value != 0.0) {
                value /= Math.sqrt(this.statsX[i].getSumsq());
            }
            vector.setValue(i, value);
        }
    }

    @Override
    public void transformInstances(Dyad dyad, List<Integer> ignoredIndices) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    public void transformAlternatives(Dyad dyad, List<Integer> ignoredIndices) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }
}

