/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.evaluation.evaluators.weka;

import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.Evaluation;
import weka.core.Instances;

public class FixedSplitClassifierEvaluator
implements IClassifierEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(FixedSplitClassifierEvaluator.class);
    private final Instances train;
    private final Instances validate;

    public FixedSplitClassifierEvaluator(Instances train, Instances validate) {
        this.train = train;
        this.validate = validate;
    }

    public Double evaluate(Classifier c) throws InterruptedException {
        try {
            c.buildClassifier(this.train);
            Evaluation eval = new Evaluation(this.train);
            eval.evaluateModel(c, this.validate, new Object[0]);
            return eval.errorRate();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("Evaluation of classifier failed due Exception {} with message {}. Returning null.", (Object)e.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }

    public Instances getTrain() {
        return this.train;
    }

    public Instances getValidate() {
        return this.validate;
    }
}

