/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.evaluation.evaluators.weka;

import ai.libs.jaicore.basic.IInformedObjectEvaluatorExtension;
import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.splitevaluation.ISplitBasedClassifierEvaluator;
import ai.libs.jaicore.ml.weka.dataset.splitter.IDatasetSplitter;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.inference.TTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class ProbabilisticMonteCarloCrossValidationEvaluator
implements IClassifierEvaluator,
IInformedObjectEvaluatorExtension<Double>,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(ProbabilisticMonteCarloCrossValidationEvaluator.class);
    private boolean canceled = false;
    private final int repeats;
    private final Instances data;
    private final double trainingPortion;
    private final long seed;
    private double bestScore = 1.0;
    private final ISplitBasedClassifierEvaluator<Double> bridge;
    private final IDatasetSplitter datasetSplitter;

    public void updateBestScore(Double bestScore) {
        this.bestScore = bestScore;
    }

    public ProbabilisticMonteCarloCrossValidationEvaluator(ISplitBasedClassifierEvaluator<Double> bridge, IDatasetSplitter datasetSplitter, int repeats, double bestscore, Instances data, double trainingPortion, long seed) {
        this.repeats = repeats;
        this.bridge = bridge;
        this.data = data;
        this.trainingPortion = trainingPortion;
        this.seed = seed;
        this.bestScore = bestscore;
        this.datasetSplitter = datasetSplitter;
    }

    public void cancel() {
        this.logger.info("Received cancel");
        this.canceled = true;
    }

    public Double evaluate(Classifier pl) throws ObjectEvaluationFailedException, InterruptedException {
        return this.evaluate(pl, new DescriptiveStatistics());
    }

    public Double evaluate(Classifier pl, DescriptiveStatistics stats) throws ObjectEvaluationFailedException, InterruptedException {
        if (pl == null) {
            throw new IllegalArgumentException("Cannot compute score for null pipeline!");
        }
        this.logger.info("Starting evaluation of {}", (Object)pl);
        for (int i = 0; i < this.repeats && !this.canceled && !Thread.currentThread().isInterrupted(); ++i) {
            this.logger.debug("Obtaining predictions of {} for split #{}/{}", new Object[]{pl, i + 1, this.repeats});
            try {
                TTest test;
                List<Instances> split = this.datasetSplitter.split(this.data, this.seed + (long)i, this.trainingPortion);
                double score = this.bridge.evaluateSplit(pl, split.get(0), split.get(1));
                this.logger.info("Score for evaluation of {} with split #{}/{}: {}", new Object[]{pl, i + 1, this.repeats, score});
                stats.addValue(score);
                if (!(stats.getMean() > this.bestScore) || stats.getN() < 2L || !(test = new TTest()).tTest(this.bestScore, stats.getValues(), 0.02)) continue;
                Double result = stats.getMean();
                this.logger.info("Obtained score of {} for classifier {}. {}-MCCV was not completed because it would have been to unliky to beat best score.", new Object[]{result, pl, this.repeats});
                return result;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ObjectEvaluationFailedException("Could not evaluate classifier!", (Throwable)e);
            }
        }
        if (Thread.interrupted()) {
            throw new InterruptedException("MCCV has been interrupted");
        }
        Double score = stats.getMean();
        this.logger.info("Obtained score of {} for classifier {}.", (Object)score, (Object)pl);
        return score;
    }

    public ISplitBasedClassifierEvaluator<Double> getBridge() {
        return this.bridge;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger of {} from {} to {}", new Object[]{this, this.logger.getName(), name});
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched logger of {} to {}", (Object)this, (Object)name);
    }
}

