/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.experiments;

import java.io.File;
import org.aeonbits.owner.Config;

@Config.Sources(value={"file:conf/eval.properties"})
public interface IPipelineEvaluationConf
extends Config {
    public static final String PREFIX = "pleval.";
    public static final String PREFIX_SELECTION = "pleval.selection.";
    public static final String PREFIX_MEM = "pleval.mem.";
    public static final String TIMEOUT_TOTAL = "pleval.timeout.total";
    public static final String TIMEOUT_CANDIDATE = "pleval.timeout.candidate";
    public static final String CPUS = "pleval.cpus";
    public static final String MEM_MAX = "pleval.mem.max";
    public static final String MEM_OPP = "pleval.mem.opp";
    public static final String RUNS = "pleval.runs";
    public static final String TMPDIR = "pleval.tmpdir";
    public static final String TRAINING = "pleval.training";
    public static final String PHASE2 = "pleval.phase2";
    public static final String SELECTION_ITERATIONS = "pleval.selection.iterations";
    public static final String SELECTION_CANDIDATES = "pleval.selection.numberofcandidates";
    public static final String SOLUTIONLOGDIR = "pleval.logdir";
    public static final String VALIDATION = "pleval.validation";

    @Config.Key(value="pleval.timeout.total")
    public int getTimeoutTotal();

    @Config.Key(value="pleval.timeout.candidate")
    public int getTimeoutPerCandidate();

    @Config.Key(value="pleval.cpus")
    public int getNumberOfAllowedCPUs();

    @Config.Key(value="pleval.mem.max")
    public int getMemoryLimitinMB();

    @Config.Key(value="pleval.mem.opp")
    public int getAssumedMemoryOverheadPerProcess();

    @Config.Key(value="pleval.runs")
    public int getNumberOfRuns();

    @Config.Key(value="pleval.tmpdir")
    public File getTmpDir();

    @Config.Key(value="pleval.logdir")
    public File getSolutionLogDir();

    @Config.Key(value="pleval.training")
    public int getTrainingPortion();

    @Config.Key(value="pleval.phase2")
    public int getPortionOfDataForPhase2();

    @Config.Key(value="pleval.validation")
    public String getValidationAlgorithm();

    @Config.Key(value="pleval.selection.iterations")
    public int getNumberOfIterationsInSelectionPhase();

    @Config.Key(value="pleval.selection.numberofcandidates")
    public int getNumberOfCandidatesInSelectionPhase();
}

