/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.experiments;

public class MLExperiment {
    private final String dataset;
    private final String algorithm;
    private final String algorithmMode;
    private final int seed;
    private final int timeoutInSeconds;
    private final int cpus;
    private final int memoryInMB;
    private final String performanceMeasure;

    public MLExperiment(String dataset, String algorithm, String algorithmMode, int seed, int timeoutInSeconds, int cpus, int memoryInMB, String performanceMeasure) {
        this.dataset = dataset;
        this.algorithm = algorithm;
        this.algorithmMode = algorithmMode;
        this.seed = seed;
        this.timeoutInSeconds = timeoutInSeconds;
        this.cpus = cpus;
        this.memoryInMB = memoryInMB;
        this.performanceMeasure = performanceMeasure;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getAlgorithmMode() {
        return this.algorithmMode;
    }

    public int getSeed() {
        return this.seed;
    }

    public int getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public int getCpus() {
        return this.cpus;
    }

    public int getMemoryInMB() {
        return this.memoryInMB;
    }

    public String getPerformanceMeasure() {
        return this.performanceMeasure;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + (this.algorithmMode == null ? 0 : this.algorithmMode.hashCode());
        result = 31 * result + this.cpus;
        result = 31 * result + (this.dataset == null ? 0 : this.dataset.hashCode());
        result = 31 * result + this.memoryInMB;
        result = 31 * result + (this.performanceMeasure == null ? 0 : this.performanceMeasure.hashCode());
        result = 31 * result + this.seed;
        result = 31 * result + this.timeoutInSeconds;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MLExperiment other = (MLExperiment)obj;
        if (this.algorithm == null ? other.algorithm != null : !this.algorithm.equals(other.algorithm)) {
            return false;
        }
        if (this.algorithmMode == null ? other.algorithmMode != null : !this.algorithmMode.equals(other.algorithmMode)) {
            return false;
        }
        if (this.cpus != other.cpus) {
            return false;
        }
        if (this.dataset == null ? other.dataset != null : !this.dataset.equals(other.dataset)) {
            return false;
        }
        if (this.memoryInMB != other.memoryInMB) {
            return false;
        }
        if (this.performanceMeasure == null ? other.performanceMeasure != null : !this.performanceMeasure.equals(other.performanceMeasure)) {
            return false;
        }
        if (this.seed != other.seed) {
            return false;
        }
        return this.timeoutInSeconds == other.timeoutInSeconds;
    }

    public String toString() {
        return "Experiment [dataset=" + this.dataset + ", algorithm=" + this.algorithm + ", algorithmMode=" + this.algorithmMode + ", seed=" + this.seed + ", timeoutInSeconds=" + this.timeoutInSeconds + ", cpus=" + this.cpus + ", memoryInMB=" + this.memoryInMB + ", performanceMeasure=" + this.performanceMeasure + "]";
    }
}

