/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.intervaltree.aggregation;

import ai.libs.jaicore.ml.intervaltree.aggregation.IntervalAggregator;
import java.util.List;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

public class QuantileAggregator
implements IntervalAggregator {
    private static final long serialVersionUID = -6765279710955694443L;
    private final Percentile maxQuantile;
    private final Percentile minQuantile;

    public QuantileAggregator(double quantile) {
        if (quantile < 0.0 || quantile > 1.0) {
            throw new IllegalArgumentException("Quantile values have to be in [0, 1]");
        }
        this.maxQuantile = new Percentile(1.0 - quantile);
        this.minQuantile = new Percentile(quantile);
    }

    @Override
    public Interval aggregate(List<Double> toAggregate) {
        double[] mappedValues = new double[toAggregate.size()];
        for (int i = 0; i < toAggregate.size(); ++i) {
            mappedValues[i] = toAggregate.get(i);
        }
        double min = this.minQuantile.evaluate(mappedValues);
        double max = this.maxQuantile.evaluate(mappedValues);
        return new Interval(min, max);
    }
}

