/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.learningcurve.extrapolation.lcnet;

import ai.libs.jaicore.ml.core.exception.TrainingException;
import ai.libs.jaicore.ml.interfaces.LearningCurve;
import ai.libs.jaicore.ml.learningcurve.extrapolation.InvalidAnchorPointsException;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolationMethod;
import ai.libs.jaicore.ml.learningcurve.extrapolation.lcnet.LCNetClient;
import ai.libs.jaicore.ml.learningcurve.extrapolation.lcnet.PointWiseLearningCurve;
import java.io.IOException;

public class LCNetExtrapolationMethod
implements LearningCurveExtrapolationMethod {
    private LCNetClient lcNet = new LCNetClient();
    private String identifier;
    private double[] configurations;

    public LCNetExtrapolationMethod(String identifier) {
        this.identifier = identifier;
        this.configurations = null;
    }

    public void setConfigurations(double[] configurations) {
        this.configurations = configurations;
    }

    @Override
    public LearningCurve extrapolateLearningCurveFromAnchorPoints(int[] xValues, double[] yValues, int dataSetSize) throws InvalidAnchorPointsException {
        if (this.configurations == null) {
            throw new UnsupportedOperationException("Configurations is not allowed to be null");
        }
        return new PointWiseLearningCurve(dataSetSize, this.configurations, this.identifier);
    }

    public void deleteNet() throws IOException {
        this.lcNet.deleteNet(this.identifier);
    }

    public void trainNet(int[] xValues, double[] yValues, int dataSetSize, double[][] configurations) throws TrainingException {
        this.lcNet.train(xValues, yValues, dataSetSize, configurations, this.identifier);
    }
}

