/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.scikitwrapper;

import ai.libs.jaicore.ml.scikitwrapper.IProcessListener;
import ai.libs.jaicore.processes.ProcessUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public abstract class AProcessListener
implements IProcessListener {
    @Override
    public void listenTo(Process process) throws IOException, InterruptedException {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
             BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            while (process.isAlive()) {
                String line;
                if (Thread.currentThread().isInterrupted()) {
                    ProcessUtil.killProcess((Process)process);
                    throw new InterruptedException("Process execution was interrupted.");
                }
                while ((line = input.readLine()) != null) {
                    if (line.contains("import imp") || line.contains("imp module")) continue;
                    this.handleInput(line);
                }
                while ((line = error.readLine()) != null) {
                    if (line.contains("import imp") || line.contains("imp module")) continue;
                    this.handleError(line);
                }
            }
        }
    }

    public abstract void handleError(String var1) throws IOException, InterruptedException;

    public abstract void handleInput(String var1) throws IOException, InterruptedException;
}

