/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.classifier;

import ai.libs.jaicore.ml.core.exception.PredictionException;
import ai.libs.jaicore.ml.tsc.HistogramBuilder;
import ai.libs.jaicore.ml.tsc.classifier.ASimplifiedTSClassifier;
import ai.libs.jaicore.ml.tsc.classifier.BOSSLearningAlgorithm;
import ai.libs.jaicore.ml.tsc.dataset.TimeSeriesDataset;
import ai.libs.jaicore.ml.tsc.filter.SFA;
import ai.libs.jaicore.ml.tsc.filter.SlidingWindowBuilder;
import ai.libs.jaicore.ml.tsc.filter.ZTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aeonbits.owner.ConfigCache;

public class BOSSClassifier
extends ASimplifiedTSClassifier<Integer> {
    private TimeSeriesDataset trainingData;
    private final BOSSLearningAlgorithm.IBossAlgorithmConfig config;
    private List<Map<Integer, Integer>> univirateHistograms;
    private SlidingWindowBuilder slide = new SlidingWindowBuilder();
    private HistogramBuilder histoBuilder = new HistogramBuilder();
    private ZTransformer znorm = new ZTransformer();

    public BOSSClassifier(int windowLength, int alphabetSize, double[] alphabet, int wordLength, boolean meanCorrected) {
        this.config = (BOSSLearningAlgorithm.IBossAlgorithmConfig)ConfigCache.getOrCreate(BOSSLearningAlgorithm.IBossAlgorithmConfig.class, (Map[])new Map[0]);
        this.config.setProperty("boss.windowsize", "" + windowLength);
        this.config.setProperty("boss.alphabetsize", "" + alphabetSize);
        this.config.setProperty("boss.alphabet", "" + alphabet);
        this.config.setProperty("boss.wordlength", "" + wordLength);
        this.config.setProperty("boss.meancorrected", "" + meanCorrected);
        this.slide.setDefaultWindowSize(this.config.windowSize());
    }

    public BOSSClassifier(BOSSLearningAlgorithm.IBossAlgorithmConfig config) {
        this.config = config;
        this.slide.setDefaultWindowSize(config.windowSize());
    }

    public List<Map<Integer, Integer>> getUnivirateHistograms() {
        return this.univirateHistograms;
    }

    public void setTrainingData(TimeSeriesDataset trainingData) {
        this.trainingData = trainingData;
    }

    public void setHistogramUnivirate(List<Map<Integer, Integer>> histograms) {
        this.univirateHistograms = histograms;
    }

    @Override
    public Integer predict(double[] univInstance) throws PredictionException {
        SFA sfa = new SFA(this.config.alphabet(), this.config.wordLength());
        TimeSeriesDataset tmp = this.slide.specialFitTransform(univInstance);
        for (int instance = 0; instance < tmp.getValues(0).length; ++instance) {
            tmp.getValues((int)0)[instance] = this.znorm.fitTransform(tmp.getValues(0)[instance]);
        }
        TimeSeriesDataset tmpznormedsfaTransformed = sfa.fitTransform(tmp);
        Map<Integer, Integer> histogram = this.histoBuilder.histogramForInstance(tmpznormedsfaTransformed);
        int indexOFminDistInstance = 0;
        double minDist = Double.MAX_VALUE;
        for (int i = 0; i < this.univirateHistograms.size(); ++i) {
            double dist = this.getBossDistance(histogram, this.univirateHistograms.get(i));
            if (!(dist < minDist)) continue;
            minDist = dist;
            indexOFminDistInstance = i;
        }
        return this.trainingData.getTargets()[indexOFminDistInstance];
    }

    @Override
    public Integer predict(List<double[]> multivInstance) throws PredictionException {
        throw new UnsupportedOperationException("The BOSS classifier is a univariat classifer");
    }

    @Override
    public List<Integer> predict(TimeSeriesDataset dataset) throws PredictionException {
        ArrayList<Integer> predictions = new ArrayList<Integer>();
        for (double[][] matrix : dataset.getValueMatrices()) {
            for (double[] instance : matrix) {
                predictions.add(this.predict(instance));
            }
        }
        return predictions;
    }

    private double getBossDistance(Map<Integer, Integer> a, Map<Integer, Integer> b) {
        double result = 0.0;
        for (Map.Entry<Integer, Integer> entry : a.entrySet()) {
            int key = entry.getKey();
            int val = entry.getValue();
            if (b.containsKey(key)) {
                result += Math.pow((double)val - (double)b.get(key).intValue(), 2.0);
                continue;
            }
            result += Math.pow(val, 2.0);
        }
        return result;
    }

    public BOSSLearningAlgorithm getLearningAlgorithm(TimeSeriesDataset dataset) {
        return new BOSSLearningAlgorithm(this.config, this, dataset);
    }
}

