/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.classifier;

import ai.libs.jaicore.ml.core.dataset.TimeSeriesDataset;
import ai.libs.jaicore.ml.core.dataset.TimeSeriesInstance;
import ai.libs.jaicore.ml.core.exception.ConfigurationException;
import ai.libs.jaicore.ml.core.exception.PredictionException;
import ai.libs.jaicore.ml.core.exception.TrainingException;
import ai.libs.jaicore.ml.core.predictivemodel.ABatchLearner;
import ai.libs.jaicore.ml.core.predictivemodel.IBatchLearner;
import ai.libs.jaicore.ml.core.predictivemodel.IPredictiveModelConfiguration;
import ai.libs.jaicore.ml.tsc.classifier.ATSCAlgorithm;
import java.util.ArrayList;
import java.util.List;

public abstract class TSClassifier<L, V, D extends TimeSeriesDataset<L>>
extends ABatchLearner<L, V, TimeSeriesInstance<L>, D> {
    protected ATSCAlgorithm<L, V, D, ? extends TSClassifier<L, V, D>> algorithm;

    public TSClassifier(ATSCAlgorithm<L, V, D, ? extends TSClassifier<L, V, D>> algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void train(D dataset) throws TrainingException {
        this.algorithm.setModel(this);
        this.algorithm.setInput(dataset);
        try {
            this.algorithm.call();
        }
        catch (Exception e) {
            throw new TrainingException("Could not train model " + this.getClass().getSimpleName(), e);
        }
    }

    public ATSCAlgorithm<L, V, D, ? extends IBatchLearner<V, TimeSeriesInstance<L>, D>> getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(ATSCAlgorithm<L, V, D, ? extends IBatchLearner<V, TimeSeriesInstance<L>, D>> algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public List<V> predict(D dataset) throws PredictionException {
        ArrayList result = new ArrayList();
        for (TimeSeriesInstance inst : dataset) {
            result.add(this.predict(inst));
        }
        return result;
    }

    @Override
    public IPredictiveModelConfiguration getConfiguration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setConfiguration(IPredictiveModelConfiguration configuration) throws ConfigurationException {
        throw new UnsupportedOperationException();
    }
}

