/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.distances;

import ai.libs.jaicore.ml.tsc.complexity.ITimeSeriesComplexity;
import ai.libs.jaicore.ml.tsc.distances.ITimeSeriesDistance;

public class ComplexityInvariantDistance
implements ITimeSeriesDistance {
    private ITimeSeriesDistance distanceMeasure;
    private ITimeSeriesComplexity complexityMeasure;

    ComplexityInvariantDistance(ITimeSeriesDistance distanceMeasure, ITimeSeriesComplexity complexityMeasure) {
        if (distanceMeasure == null) {
            throw new IllegalArgumentException("The distance measure must not be null.");
        }
        if (complexityMeasure == null) {
            throw new IllegalArgumentException("The complexity measure must not be null.");
        }
        this.distanceMeasure = distanceMeasure;
        this.complexityMeasure = complexityMeasure;
    }

    @Override
    public double distance(double[] a, double[] b) {
        double complexityA = this.complexityMeasure.complexity(a);
        double complexityB = this.complexityMeasure.complexity(b);
        double complexityCorrectionFactor = Math.max(complexityA, complexityB) / Math.min(complexityA, complexityB);
        return this.distanceMeasure.distance(a, b) * complexityCorrectionFactor;
    }
}

