/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.distances;

import ai.libs.jaicore.ml.tsc.distances.AWeightedTrigometricDistance;
import ai.libs.jaicore.ml.tsc.distances.ITimeSeriesDistance;
import ai.libs.jaicore.ml.tsc.filter.derivate.ADerivateFilter;
import ai.libs.jaicore.ml.tsc.filter.derivate.BackwardDifferenceDerivate;

public class DerivateDistance
extends AWeightedTrigometricDistance {
    private ADerivateFilter derivate;
    private ITimeSeriesDistance timeSeriesDistance;
    private ITimeSeriesDistance baseDerivateDistance;

    public DerivateDistance(double alpha, ADerivateFilter derivate, ITimeSeriesDistance timeSeriesDistance, ITimeSeriesDistance derivateDistance) {
        super(alpha);
        if (derivate == null) {
            throw new IllegalArgumentException("Parameter derivate must not be null.");
        }
        if (timeSeriesDistance == null) {
            throw new IllegalArgumentException("Parameter timeSeriesDistance must not be null.");
        }
        if (derivateDistance == null) {
            throw new IllegalArgumentException("Parameter derivateDistance must not be null.");
        }
        this.derivate = derivate;
        this.timeSeriesDistance = timeSeriesDistance;
        this.baseDerivateDistance = derivateDistance;
    }

    public DerivateDistance(double alpha, ITimeSeriesDistance timeSeriesDistance, ITimeSeriesDistance derivateDistance) {
        this(alpha, new BackwardDifferenceDerivate(), timeSeriesDistance, derivateDistance);
    }

    public DerivateDistance(double alpha, ADerivateFilter derivate, ITimeSeriesDistance distance) {
        this(alpha, derivate, distance, distance);
    }

    public DerivateDistance(double alpha, ITimeSeriesDistance distance) {
        this(alpha, new BackwardDifferenceDerivate(), distance, distance);
    }

    @Override
    public double distance(double[] a, double[] b) {
        double[] derivateA = this.derivate.transform(a);
        double[] derivateB = this.derivate.transform(b);
        return this.getA() * this.timeSeriesDistance.distance(a, b) + this.getB() * this.baseDerivateDistance.distance(derivateA, derivateB);
    }
}

