/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.distances;

import ai.libs.jaicore.ml.tsc.distances.IScalarDistance;
import ai.libs.jaicore.ml.tsc.distances.ITimeSeriesDistance;
import java.util.HashMap;
import java.util.Map;

public class WeightedDynamicTimeWarping
implements ITimeSeriesDistance {
    private double g;
    private double maximumWeight;
    private IScalarDistance d;
    private Map<Integer, double[]> weightMemoization = new HashMap<Integer, double[]>();

    public WeightedDynamicTimeWarping(double g, double maximumWeight, IScalarDistance d) {
        this.g = g;
        this.maximumWeight = maximumWeight;
        this.d = d;
    }

    @Override
    public double distance(double[] a, double[] b) {
        int i;
        int n = a.length;
        int m = b.length;
        double[][] matrix = new double[n + 1][m + 1];
        double[] weights = this.calculateWeights(Math.max(n, m));
        for (i = 1; i <= n; ++i) {
            matrix[i][0] = Double.MAX_VALUE;
        }
        for (int j = 1; j <= m; ++j) {
            matrix[0][j] = Double.MAX_VALUE;
        }
        matrix[0][0] = 0.0;
        for (i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                double cost = weights[Math.abs(i - j)] * this.d.distance(a[i - 1], b[j - 1]);
                double minimum = Math.min(matrix[i - 1][j], Math.min(matrix[i][j - 1], matrix[i - 1][j - 1]));
                matrix[i][j] = cost + minimum;
            }
        }
        return matrix[n][m];
    }

    protected double[] calculateWeights(int length) {
        double[] memoized = this.weightMemoization.get(length);
        if (memoized != null) {
            return memoized;
        }
        double[] weights = new double[length];
        double halfLength = (double)length / 2.0;
        for (int i = 0; i < length; ++i) {
            weights[i] = this.maximumWeight / (1.0 + Math.exp(-this.g * ((double)i - halfLength)));
        }
        this.weightMemoization.put(length, weights);
        return weights;
    }
}

