/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.shapelets.search;

import ai.libs.jaicore.ml.tsc.shapelets.Shapelet;
import ai.libs.jaicore.ml.tsc.shapelets.search.AMinimumDistanceSearchStrategy;
import ai.libs.jaicore.ml.tsc.util.MathUtil;
import ai.libs.jaicore.ml.tsc.util.TimeSeriesUtil;
import java.util.List;

public class EarlyAbandonMinimumDistanceSearchStrategy
extends AMinimumDistanceSearchStrategy {
    public EarlyAbandonMinimumDistanceSearchStrategy(boolean useBiasCorrection) {
        super(useBiasCorrection);
    }

    @Override
    public double findMinimumDistance(Shapelet shapelet, double[] timeSeries) {
        double length = shapelet.getLength();
        int m = timeSeries.length;
        double[] sPrimeVector = shapelet.getData();
        List<Integer> aVector = TimeSeriesUtil.sortIndexes(sPrimeVector, false);
        double[] fVector = TimeSeriesUtil.zNormalize(TimeSeriesUtil.getInterval(timeSeries, 0, shapelet.getLength()), this.useBiasCorrection);
        double p = 0.0;
        double q = 0.0;
        p = MathUtil.sum(TimeSeriesUtil.getInterval(timeSeries, 0, shapelet.getLength()));
        int i = 0;
        while ((double)i < length) {
            q += timeSeries[i] * timeSeries[i];
            ++i;
        }
        double b = MathUtil.singleSquaredEuclideanDistance(sPrimeVector, fVector);
        int i2 = 1;
        while ((double)i2 <= (double)m - length) {
            double ti = timeSeries[i2 - 1];
            double til = timeSeries[i2 - 1 + shapelet.getLength()];
            p -= ti;
            q -= ti * ti;
            double xBar = (p += til) / length;
            double s = (q += til * til) / length - xBar * xBar;
            s = s < 1.0E-9 ? 0.0 : Math.sqrt((this.useBiasCorrection ? length / (length - 1.0) : 1.0) * s);
            int j = 0;
            double d = 0.0;
            while ((double)j < length && d < b) {
                double normVal = s == 0.0 ? 0.0 : (timeSeries[i2 + aVector.get(j)] - xBar) / s;
                double diff = sPrimeVector[aVector.get(j)] - normVal;
                d += diff * diff;
                ++j;
            }
            if ((double)j == length && d < b) {
                b = d;
            }
            ++i2;
        }
        return b / length;
    }
}

