/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.activelearning;

import ai.libs.jaicore.ml.activelearning.IActiveLearningPoolProvider;
import ai.libs.jaicore.ml.activelearning.ISelectiveSamplingStrategy;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.ILabeledInstance;
import ai.libs.jaicore.ml.core.predictivemodel.ICertaintyProvider;

public class PoolBasedUncertaintySamplingStrategy<T, I extends ILabeledInstance, D extends IDataset<I>>
implements ISelectiveSamplingStrategy<I> {
    private ICertaintyProvider<T, I, D> certaintyProvider;
    private IActiveLearningPoolProvider<I> poolProvider;

    public PoolBasedUncertaintySamplingStrategy(ICertaintyProvider<T, I, D> certaintyProivder, IActiveLearningPoolProvider<I> poolProvider) {
        this.certaintyProvider = certaintyProivder;
        this.poolProvider = poolProvider;
    }

    @Override
    public I nextQueryInstance() {
        double currentlyLowestCertainty = Double.MAX_VALUE;
        ILabeledInstance currentlyLeastCertainInstance = null;
        for (ILabeledInstance instance : this.poolProvider.getPool()) {
            double currentCertainty = this.certaintyProvider.getCertainty(instance);
            if (!(currentCertainty < currentlyLowestCertainty)) continue;
            currentlyLowestCertainty = currentCertainty;
            currentlyLeastCertainInstance = instance;
        }
        return (I)currentlyLeastCertainInstance;
    }
}

