/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.cache;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.ml.cache.Instruction;
import ai.libs.jaicore.ml.cache.InstructionFailedException;
import ai.libs.jaicore.ml.cache.InstructionNode;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import com.clearspring.analytics.util.Lists;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class InstructionGraph
extends ArrayList<InstructionNode> {
    private static final long serialVersionUID = -2808542161976307180L;
    @JsonIgnore
    private final Map<String, InstructionNode> nodeMap = new HashMap<String, InstructionNode>();

    public InstructionGraph() {
    }

    public static InstructionGraph fromJson(String jsonRepresentation) throws IOException {
        return (InstructionGraph)new ObjectMapper().readValue(jsonRepresentation, InstructionGraph.class);
    }

    public InstructionGraph(InstructionGraph toClone) {
        for (InstructionNode node : toClone) {
            ArrayList<Pair<String, Integer>> inputs = new ArrayList<Pair<String, Integer>>();
            for (Pair<String, Integer> pair : node.getInputs()) {
                inputs.add((Pair<String, Integer>)new Pair((Object)((String)pair.getX()), (Object)((Integer)pair.getY())));
            }
            this.addNode(node.getName(), node.getInstruction().clone(), inputs);
        }
    }

    public InstructionNode addNode(String name, Instruction instruction) {
        return this.addNode(name, instruction, Lists.newArrayList());
    }

    public InstructionNode addNode(String name, Instruction instruction, List<Pair<String, Integer>> inputs) {
        InstructionNode node = new InstructionNode(this, name, instruction, inputs);
        this.nodeMap.put(name, node);
        this.add(node);
        return node;
    }

    public InstructionNode getNodeByName(String name) {
        return this.nodeMap.get(name);
    }

    private void synchronizeNodeMap() {
        SetUtil.difference(this.nodeMap.keySet(), (Collection)this.stream().map(InstructionNode::getName).collect(Collectors.toList())).forEach(this.nodeMap::remove);
        for (InstructionNode node : this) {
            this.nodeMap.computeIfAbsent(node.getName(), k -> node);
        }
    }

    public IDataset getDataForUnit(Pair<String, Integer> unit) throws InstructionFailedException, InterruptedException {
        this.synchronizeNodeMap();
        InstructionNode node = this.nodeMap.get(unit.getX());
        ArrayList<IDataset> inputs = new ArrayList<IDataset>();
        if (node.getInputs() != null) {
            for (Pair<String, Integer> inputProvider : node.getInputs()) {
                IDataset input = this.getDataForUnit(inputProvider);
                inputs.add(input);
            }
        }
        return node.getInstruction().getOutputInstances(inputs).get((Integer)unit.getY());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.nodeMap.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstructionGraph other = (InstructionGraph)obj;
        return new EqualsBuilder().append(this.nodeMap, other.nodeMap).isEquals();
    }
}

